/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.ArtifactProjectorTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerGreedData;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ArtifactProjectorBlock
extends FacedBlock
implements EntityBlock {
    public ArtifactProjectorBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof ArtifactProjectorTileEntity) {
            ArtifactProjectorTileEntity artifactProjectorTileEntity = (ArtifactProjectorTileEntity)be;
            if (!artifactProjectorTileEntity.consuming) {
                if (pLevel instanceof ServerLevel) {
                    ServerLevel sWorld = (ServerLevel)pLevel;
                    artifactProjectorTileEntity.consume(pPlayer);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return LecternBlock.f_54470_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return LecternBlock.f_54472_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> LecternBlock.f_54474_;
            case Direction.NORTH -> LecternBlock.f_54476_;
            case Direction.WEST -> LecternBlock.f_54475_;
            case Direction.EAST -> LecternBlock.f_54473_;
            default -> LecternBlock.f_54470_;
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.ARTIFACT_PROJECTOR_ENTITY.m_155264_(pos, state);
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level level, BlockState state, BlockEntityType<A> blockEntityType) {
        return level.m_5776_() ? BlockHelper.getTicker(blockEntityType, ModBlocks.ARTIFACT_PROJECTOR_ENTITY, ArtifactProjectorTileEntity::tickClient) : BlockHelper.getTicker(blockEntityType, ModBlocks.ARTIFACT_PROJECTOR_ENTITY, ArtifactProjectorTileEntity::tickServer);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pLevel.f_46443_) {
            return;
        }
        ArtifactProjectorTileEntity projectorTile = (ArtifactProjectorTileEntity)pLevel.m_7702_(pPos);
        if (projectorTile == null || !(pPlacer instanceof Player)) {
            return;
        }
        projectorTile.setOwner(pPlacer.m_142081_());
        if (PlayerGreedData.get().get(pPlacer.m_142081_()).hasCompletedArtifacts()) {
            projectorTile.completed = true;
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }
}

