/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.AscensionForgeTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AscensionForgeBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public AscensionForgeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f).m_60953_(state -> 7).m_60955_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof AscensionForgeTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        AscensionForgeTileEntity ascensionForgeTileEntity = (AscensionForgeTileEntity)tile;
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)ascensionForgeTileEntity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60780_((BlockGetter)reader, (BlockPos)pos).f_76396_;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.ASCENSION_FORGE_TILE_ENTITY.m_155264_(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (random.nextInt(3) != 0) {
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.4375, 0.0);
        for (int i = 0; i < 1 + level.f_46441_.nextInt(5); ++i) {
            float distRandom = random.nextFloat();
            float dist = 0.0625f + 0.25f * distRandom;
            float angle = random.nextFloat() * (float)Math.PI * 2.0f;
            Vec3 offset = new Vec3(Math.cos(angle) * (double)dist, 0.0, Math.sin(angle) * (double)dist);
            Vec3 pos1 = center.m_82549_(offset);
            float speed = 0.03f;
            double particleAngle = 1.413716694115407 - (double)distRandom * Math.PI / 4.0;
            Vec3 speedVector = new Vec3(Math.cos(particleAngle) * Math.cos(angle) * (double)speed, Math.sin(particleAngle) * (double)speed, Math.cos(particleAngle) * Math.sin(angle) * (double)speed);
            level.m_7106_((ParticleOptions)ModParticles.ASCENSION_FORGE.get(), pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, speedVector.f_82479_, speedVector.f_82480_, speedVector.f_82481_);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof AscensionForgeTileEntity) {
                AscensionForgeTileEntity ascensionForgeTileEntity = (AscensionForgeTileEntity)blockentity;
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)ascensionForgeTileEntity.getInternalInventory());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }
}

