/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.CardEssenceExtractorTileEntity;
import iskallia.vault.container.inventory.CardEssenceExtractorContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class CardEssenceExtractorBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape SHAPE_SN = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EW = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);

    public CardEssenceExtractorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 6.0f).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122434_() == Direction.Axis.X) {
            return SHAPE_EW;
        }
        return SHAPE_SN;
    }

    public InteractionResult m_6227_(BlockState state, final Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof CardEssenceExtractorTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return CardEssenceExtractorBlock.this.m_49954_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                return new CardEssenceExtractorContainer(id, level, pos, inventory);
            }
        }, buf -> buf.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, level, pos, block, fromPos, moving);
        BlockPos diff = pos.m_141950_((Vec3i)fromPos);
        Direction dir = Direction.m_175360_((BlockPos)diff);
        if (dir == null) {
            return;
        }
        boolean hasPower = level.m_46616_(fromPos, dir.m_122424_());
        if (!hasPower) {
            return;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CardEssenceExtractorTileEntity) {
            CardEssenceExtractorTileEntity tile = (CardEssenceExtractorTileEntity)entity;
            tile.startExtract();
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof CardEssenceExtractorTileEntity) {
            CardEssenceExtractorTileEntity entity = (CardEssenceExtractorTileEntity)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)this);
            entity.m_187476_(stack);
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.CARD_ESSENCE_EXTRACTOR_TILE_ENTITY, CardEssenceExtractorTileEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.CARD_ESSENCE_EXTRACTOR_TILE_ENTITY.m_155264_(pos, state);
    }
}

