/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.base.InventoryRetainerBlock;
import iskallia.vault.block.entity.CatalystInfusionTableTileEntity;
import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.init.ModBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class CatalystInfusionBlock
extends FacedBlock
implements EntityBlock,
InventoryRetainerBlock<CatalystInfusionTableTileEntity> {
    public CatalystInfusionBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 3600000.0f).m_60955_());
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return LecternBlock.f_54470_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return LecternBlock.f_54472_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> LecternBlock.f_54474_;
            case Direction.SOUTH -> LecternBlock.f_54476_;
            case Direction.EAST -> LecternBlock.f_54475_;
            case Direction.WEST -> LecternBlock.f_54473_;
            default -> LecternBlock.f_54470_;
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        this.addInventoryTooltip(stack, tooltip, ForgeRecipeTileEntity::addInventoryTooltip);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof CatalystInfusionTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        CatalystInfusionTableTileEntity entity = (CatalystInfusionTableTileEntity)blockEntity;
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)entity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onInventoryBlockDestroy(level, pos, state, newState);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.onInventoryBlockPlace(level, pos, stack);
    }

    @ParametersAreNonnullByDefault
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.CATALYST_INFUSION_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }
}

