/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.challenge.ChallengeControllerBlockEntity;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.VoxelUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChallengeControllerBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE_TOP = ChallengeControllerBlock.makeShape().m_83216_(0.0, -1.0, 0.0);
    private static final VoxelShape SHAPE_BOTTOM = ChallengeControllerBlock.makeShape();
    private final Supplier<BlockEntityType<? extends ChallengeControllerBlockEntity<?>>> entityType;

    public ChallengeControllerBlock(Supplier<BlockEntityType<? extends ChallengeControllerBlockEntity<?>>> entityType) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60918_(SoundType.f_56744_).m_60913_(-1.0f, 3600000.0f).m_60953_(value -> 10).m_60910_().m_60955_().m_60993_());
        this.entityType = entityType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape makeShape() {
        VoxelShape m1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape m2 = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)29.0, (double)14.0);
        return VoxelUtils.combineAll(BooleanOp.f_82695_, m1, m2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_TOP;
        }
        return SHAPE_BOTTOM;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!state.m_60713_(newState.m_60734_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                BlockState otherState = world.m_8055_(pos.m_7495_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_7471_(pos.m_7495_(), isMoving);
                }
            } else {
                BlockState otherState = world.m_8055_(pos.m_7494_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_7471_(pos.m_7494_(), isMoving);
                }
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return this.entityType.get().m_155264_(pos, state);
        }
        return null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockHelper.getTicker(pBlockEntityType, this.entityType.get(), ChallengeControllerBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)super.m_6843_(state, rotation).m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)super.m_6943_(state, mirror).m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }
}

