/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.init.ModSounds;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoinPileDecorBlock
extends Block {
    public static final IntegerProperty SIZE = IntegerProperty.m_61631_((String)"size", (int)1, (int)13);
    public static final IntegerProperty COINS = IntegerProperty.m_61631_((String)"coins", (int)1, (int)64);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)};

    public CoinPileDecorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_((SoundType)ModSounds.COIN_PILE_DECO_SOUND_TYPE).m_60955_().m_60913_(0.2f, 3.0f));
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public List<ItemStack> m_7381_(BlockState pState, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.m_7500_()) {
            this.generateLoot(level, pos, state);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void generateLoot(Level level, BlockPos pos, BlockState state) {
        int numOfCoins = (Integer)state.m_61143_((Property)COINS);
        CoinPileDecorBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)state.m_60734_().m_5456_(), numOfCoins));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)SIZE) - 1];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        return !ctx.m_7078_() && ctx.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)COINS) < 64 || super.m_6864_(state, ctx);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE, COINS, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6047_()) {
            if (!pLevel.f_46443_) {
                if ((Integer)pState.m_61143_((Property)COINS) > 1) {
                    pLevel.m_5594_(null, pPos, ModSounds.COIN_PILE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.m_46597_(pPos, CoinPileDecorBlock.updateCoinsState(pState, (Integer)pState.m_61143_((Property)COINS) - 1));
                    CoinPileDecorBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)pState.m_60734_().m_5456_(), 1));
                } else {
                    pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
                    CoinPileDecorBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)pState.m_60734_().m_5456_(), 1));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)blockentity));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pOldState.m_61138_((Property)COINS) && (Integer)pState.m_61143_((Property)COINS) > 1) {
            pLevel.m_5594_(null, pPos, ModSounds.COIN_PILE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static BlockState updateCoinsState(BlockState blockState, int newCoins) {
        int size = switch (newCoins) {
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            case 5, 6, 7 -> 5;
            case 8, 9, 10, 11, 12, 13, 14, 15 -> 6;
            case 16, 17, 18, 19, 20, 21, 22, 23 -> 7;
            case 24, 25, 26, 27, 28, 29, 30, 31 -> 8;
            case 32, 33, 34, 35, 36, 37, 38, 39 -> 9;
            case 40, 41, 42, 43, 44, 45, 46, 47 -> 10;
            case 48, 49, 50, 51, 52, 53, 54, 55 -> 11;
            case 56, 57, 58, 59, 60, 61, 62, 63 -> 12;
            case 64 -> 13;
            default -> 1;
        };
        return (BlockState)((BlockState)blockState.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size))).m_61124_((Property)COINS, (Comparable)Integer.valueOf(Math.min(64, newCoins)));
    }
}

