/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.CompanionHomeTileEntity;
import iskallia.vault.block.item.CompanionHomeBlockItem;
import iskallia.vault.container.CompanionHomeContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionPetManager;
import iskallia.vault.util.BlockHelper;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CompanionHomeBlock
extends FacedBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = CompanionHomeBlock.makeShape();
    public static final IntegerProperty COOLDOWN_PERCENT = IntegerProperty.m_61631_((String)"cooldown", (int)0, (int)10);

    private static VoxelShape makeShape() {
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    }

    public CompanionHomeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_().m_60913_(0.5f, 1200.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COOLDOWN_PERCENT, (Comparable)Integer.valueOf(10)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{COOLDOWN_PERCENT});
    }

    @Override
    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)COOLDOWN_PERCENT, (Comparable)Integer.valueOf(10));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompanionHomeTileEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CompanionHomeTileEntity) {
            CompanionHomeTileEntity home = (CompanionHomeTileEntity)be;
            if (stack.m_41720_() instanceof CompanionHomeBlockItem) {
                home.setColour(CompanionHomeBlockItem.getColour(stack, 0));
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompanionHomeTileEntity) {
            CompanionHomeTileEntity home = (CompanionHomeTileEntity)blockEntity;
            ItemStack stack = home.getCompanion();
            if (!stack.m_41619_() && !CompanionItem.isOwner(stack, player)) {
                return false;
            }
            stack = new ItemStack((ItemLike)this);
            CompanionHomeBlockItem.setColour(stack, home.getColour());
            CompanionHomeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CompanionHomeTileEntity)) {
            return InteractionResult.PASS;
        }
        CompanionHomeTileEntity tile = (CompanionHomeTileEntity)blockEntity;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            int colour = dye.m_41089_().m_41071_();
            if (tile.getColour() != colour) {
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                }
                tile.setColour(colour);
                level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        if (tile.getCompanion().m_41619_()) {
            if (held.m_41720_() instanceof CompanionItem) {
                ItemStack insert = held.m_41777_();
                insert.m_41764_(1);
                if (!player.m_150110_().f_35937_) {
                    held.m_41774_(1);
                }
                tile.setCompanion(insert);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slotKey, stacks) -> {
                if (!tile.getCompanion().m_41619_()) {
                    return;
                }
                stacks.stream().filter(t -> ((ItemStack)t.m_14418_()).m_41720_() instanceof CompanionItem).findFirst().ifPresent(t -> {
                    ItemStack curioStack = (ItemStack)t.m_14418_();
                    ItemStack insert = curioStack.m_41777_();
                    insert.m_41764_(1);
                    if (!player.m_150110_().f_35937_) {
                        IntegrationCurios.setCurioItemStack((LivingEntity)player, ItemStack.f_41583_, slotKey, (Integer)t.m_14419_());
                        if (player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            if (!level.f_46443_) {
                                CompanionPetManager.despawnPet(sp);
                            }
                        }
                    }
                    tile.setCompanion(insert);
                });
            });
            if (!tile.getCompanion().m_41619_()) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else {
            ItemStack stack;
            if (player.m_6144_()) {
                if (level.m_5776_()) {
                    return InteractionResult.SUCCESS;
                }
                if (!CompanionItem.isOwner(tile.getCompanion(), player)) {
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
                ItemStack companionStack = tile.getCompanion();
                if (player.m_21205_().m_150930_((Item)ModItems.COMPANION_HEAL)) {
                    int hearts = CompanionItem.getCompanionHearts(companionStack);
                    int maxHearts = CompanionItem.getCompanionMaxHearts(companionStack);
                    if (hearts <= 0) {
                        player.m_5661_((Component)new TextComponent("Your companion is retired..").m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.m_19078_((boolean)false);
                    }
                    if (hearts >= maxHearts) {
                        player.m_5661_((Component)new TextComponent("This companion is healthy!").m_130940_(ChatFormatting.GREEN), true);
                        return InteractionResult.m_19078_((boolean)false);
                    }
                    CompanionItem.setCompanionHearts(companionStack, Math.min(hearts + 1, maxHearts));
                    if (!player.m_150110_().f_35937_) {
                        player.m_21205_().m_41774_(1);
                    }
                    player.m_5661_((Component)new TextComponent("Your companion was healed!").m_130940_(ChatFormatting.GREEN), true);
                    return InteractionResult.m_19078_((boolean)true);
                }
                stack = tile.getCompanion();
                tile.setCompanion(ItemStack.f_41583_);
                ItemStack curioStack = IntegrationCurios.getCurioItemStack((LivingEntity)player, "head", 0);
                if (curioStack == null || curioStack.m_41619_()) {
                    IntegrationCurios.setCurioItemStack((LivingEntity)player, stack, "head", 0);
                } else if (player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, stack);
                } else if (!player.m_150109_().m_36054_(stack)) {
                    CompanionHomeBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ServerPlayer sp = (ServerPlayer)player;
            stack = tile.getCompanion();
            CompanionItem.migrateFromWorldData(stack);
            if (!CompanionItem.isOwner(stack, (Player)sp)) {
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)new CompanionHomeContainer.Provider(pos), buf -> buf.m_130064_(pos));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        CompanionHomeTileEntity home;
        ItemStack companion;
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof CompanionHomeTileEntity && !(companion = (home = (CompanionHomeTileEntity)be).getCompanion()).m_41619_()) {
            CompanionHomeBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)companion.m_41777_());
            home.setCompanion(ItemStack.f_41583_);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.COMPANION_HOME_TILE_ENTITY, CompanionHomeTileEntity::tick);
    }
}

