/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.core.DataInitializationItem;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CompanionNestBlock
extends Block {
    private static final VoxelShape SHAPE = CompanionNestBlock.makeShape();

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)-0.012499999999999956, (double)0.015625, (double)1.0, (double)0.23750000000000004, (double)0.015625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)-0.012499999999999956, (double)0.984375, (double)1.0, (double)0.23750000000000004, (double)0.984375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.015625, (double)-0.012499999999999956, (double)0.0, (double)0.015625, (double)0.23750000000000004, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.984375, (double)-0.012499999999999956, (double)0.0, (double)0.984375, (double)0.23750000000000004, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125625, (double)-0.1875, (double)0.9375, (double)0.125625, (double)1.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.1875, (double)0.12625, (double)0.125, (double)1.0625, (double)0.12625, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.126875, (double)0.0, (double)0.90625, (double)0.126875, (double)1.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.28125, (double)0.017499999999999988, (double)0.0625, (double)0.96875, (double)0.017499999999999988, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.017499999999999988, (double)-0.25, (double)0.90625, (double)0.017499999999999988, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.03125, (double)0.017499999999999988, (double)0.0625, (double)1.21875, (double)0.017499999999999988, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.017499999999999988, (double)0.0, (double)0.90625, (double)0.017499999999999988, (double)1.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.21875, (double)0.8125, (double)1.0, (double)0.78125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public CompanionNestBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(0.5f));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && !player.m_7500_()) {
            ItemStack egg = new ItemStack((ItemLike)ModItems.COMPANION_EGG);
            DataInitializationItem.doInitialize(egg);
            FloatingItemEntity floating = FloatingItemEntity.create(level, pos.m_7494_(), egg);
            floating.setColor(8957648);
            level.m_7967_((Entity)floating);
            level.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (!level.f_46443_) {
            return;
        }
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        float time = level.m_46467_();
        int spiralParticles = 64;
        float spiralHeight = 18.0f;
        float radius = 0.75f;
        for (int i = 0; i < spiralParticles; ++i) {
            float progress = ((float)i + time * 2.0f) % (float)spiralParticles / (float)spiralParticles;
            float angle = (float)((double)progress * Math.PI * 2.0 * 8.0);
            float yOffset = progress * spiralHeight;
            BlockPos target = pos.m_6630_((int)Math.floor(yOffset));
            if (level.m_8055_(target).m_60804_((BlockGetter)level, target)) continue;
            double x = (double)pos.m_123341_() + 0.5 + (double)radius * Math.cos(angle);
            double y = (float)pos.m_123342_() + yOffset;
            double z = (double)pos.m_123343_() + 0.5 + (double)radius * Math.sin(angle);
            int color = switch (i % 5) {
                case 0 -> 13169134;
                case 1 -> 16758154;
                case 2 -> 14337260;
                case 3 -> 9562523;
                default -> 8957648;
            };
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Particle p = mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, x, y, z, 0.0, 0.05, 0.0);
            if (p == null) continue;
            p.m_107253_(r, g, b);
            p.m_107257_(20);
        }
    }
}

