/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.CrystalWorkbenchTileEntity;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class CrystalWorkbenchBlock
extends FacedBlock
implements EntityBlock {
    public static VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.5, (double)7.0, (double)11.5, (double)10.5, (double)10.0, (double)12.5), Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)5.0, (double)6.0, (double)4.5, (double)11.0, (double)10.0, (double)11.5), Block.m_49796_((double)4.0, (double)7.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), Block.m_49796_((double)5.5, (double)7.0, (double)3.5, (double)10.5, (double)10.0, (double)4.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public CrystalWorkbenchBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.5f, 3600000.0f).m_60955_());
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CrystalWorkbenchTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        CrystalWorkbenchTileEntity entity = (CrystalWorkbenchTileEntity)blockEntity;
        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)entity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof CrystalWorkbenchTileEntity) {
            CrystalWorkbenchTileEntity entity = (CrystalWorkbenchTileEntity)blockEntity;
            List<OverSizedInventory> inventories = Arrays.asList(entity.getIngredients(), entity.getInput(), entity.getUniqueIngredients());
            for (OverSizedInventory inventory : inventories) {
                inventory.getOverSizedContents().forEach(overSizedStack -> overSizedStack.splitByStackSize().forEach(splitStack -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)splitStack)));
            }
            entity.getIngredients().m_6211_();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.CRYSTAL_WORKBENCH_ENTITY.m_155264_(pos, state);
    }
}

