/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.EternalPedestalTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EternalPedestalBlock
extends Block
implements EntityBlock {
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    public static final EnumProperty<TripleBlock> HALF = EnumProperty.m_61587_((String)"half", TripleBlock.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape EMPTY = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    protected static final VoxelShape SHAPE_BASE_GOLD = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)6.0, (double)8.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_BASE_GOLD_TURNED = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)4.0, (double)8.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_BASE_GOLD_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_MIDDLE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_MIDDLE_GOLD = Stream.of(Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_MIDDLE_GOLD_SLIM = Stream.of(Block.m_49796_((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), Block.m_49796_((double)6.0, (double)3.5, (double)1.0, (double)10.0, (double)15.5, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_MIDDLE_GOLD_TURNED = Stream.of(Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), Block.m_49796_((double)0.0, (double)3.75, (double)6.0, (double)16.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_MIDDLE_GOLD_TURNED_SLIM = Stream.of(Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), Block.m_49796_((double)1.0, (double)3.5, (double)6.0, (double)15.0, (double)15.5, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape SHAPE_PLAYER_GOLD = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);

    public EternalPedestalBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)((Object)TripleBlock.LOWER)));
    }

    public RenderShape m_7514_(BlockState pState) {
        if (pState.m_61143_(HALF) == TripleBlock.UPPER) {
            return RenderShape.INVISIBLE;
        }
        if (pState.m_61143_(HALF) == TripleBlock.MIDDLE) {
            return RenderShape.INVISIBLE;
        }
        return super.m_7514_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof EternalPedestalTileEntity) {
            EternalPedestalTileEntity gladiatorLadderStatueBlockEntity = (EternalPedestalTileEntity)be;
            if (pPlacer instanceof Player) {
                gladiatorLadderStatueBlockEntity.setOwner(pPlacer.m_142081_());
            } else {
                gladiatorLadderStatueBlockEntity.setOwner(null);
            }
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(HALF) == TripleBlock.LOWER ? new EternalPedestalTileEntity(pos, state) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EternalPedestalTileEntity eternalPedestalTile;
        BlockEntity blockEntity;
        boolean isSlim = false;
        if (state.m_61143_(HALF) == TripleBlock.LOWER && (blockEntity = level.m_7702_(pos)) instanceof EternalPedestalTileEntity) {
            EternalPedestalTileEntity eternalPedestalTile2 = (EternalPedestalTileEntity)blockEntity;
            if (eternalPedestalTile2.getEternalId() == null) {
                return SHAPE_BASE;
            }
        } else if (state.m_61143_(HALF) == TripleBlock.MIDDLE && (blockEntity = level.m_7702_(pos.m_7495_())) instanceof EternalPedestalTileEntity) {
            EternalPedestalTileEntity eternalPedestalTile3 = (EternalPedestalTileEntity)blockEntity;
            if (eternalPedestalTile3.getEternalId() == null) {
                return EMPTY;
            }
            isSlim = eternalPedestalTile3.getSkinProfile().isSlim();
        } else if (state.m_61143_(HALF) == TripleBlock.UPPER && (blockEntity = level.m_7702_(pos.m_7495_().m_7495_())) instanceof EternalPedestalTileEntity && (eternalPedestalTile = (EternalPedestalTileEntity)blockEntity).getEternalId() == null) {
            return EMPTY;
        }
        if (!state.m_61138_(HALF) || state.m_61143_(HALF) == TripleBlock.LOWER) {
            if (state.m_61138_((Property)FACING) && (state.m_61143_((Property)FACING) == Direction.WEST || state.m_61143_((Property)FACING) == Direction.EAST)) {
                return SHAPE_BASE_GOLD;
            }
            return SHAPE_BASE_GOLD_TURNED;
        }
        if (!state.m_61138_(HALF) || state.m_61143_(HALF) == TripleBlock.MIDDLE) {
            if (state.m_61138_((Property)FACING)) {
                if (state.m_61143_((Property)FACING) == Direction.WEST || state.m_61143_((Property)FACING) == Direction.EAST) {
                    return isSlim ? SHAPE_MIDDLE_GOLD_SLIM : SHAPE_MIDDLE_GOLD;
                }
                return isSlim ? SHAPE_MIDDLE_GOLD_TURNED_SLIM : SHAPE_MIDDLE_GOLD_TURNED;
            }
            return SHAPE_MIDDLE;
        }
        return SHAPE_PLAYER_GOLD;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (state.m_61143_(HALF) == TripleBlock.LOWER) {
            return SHAPE_BASE_GOLD_COLLISION;
        }
        return EMPTY;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.ETERNAL_PEDESTAL_TILE_ENTITY, EternalPedestalTileEntity::tick);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        if (!state.m_60713_(newState.m_60734_())) {
            BlockState otherState;
            if (state.m_61143_(HALF) == TripleBlock.UPPER) {
                otherState = world.m_8055_(pos.m_7495_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7495_(), true);
                }
                if ((otherState = world.m_8055_(pos.m_7495_().m_7495_())).m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7495_().m_7495_(), true);
                }
            }
            if (state.m_61143_(HALF) == TripleBlock.MIDDLE) {
                otherState = world.m_8055_(pos.m_7495_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7495_(), true);
                }
                if ((otherState = world.m_8055_(pos.m_7494_())).m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7494_(), true);
                }
            } else {
                otherState = world.m_8055_(pos.m_7494_());
                if (otherState.m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7494_(), true);
                }
                if ((otherState = world.m_8055_(pos.m_7494_().m_7494_())).m_60713_(state.m_60734_())) {
                    world.m_46961_(pos.m_7494_().m_7494_(), true);
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AtomicBoolean bool = new AtomicBoolean(false);
        if (state.m_61143_(HALF) == TripleBlock.UPPER) {
            pos = pos.m_7495_().m_7495_();
        }
        if (state.m_61143_(HALF) == TripleBlock.MIDDLE) {
            pos = pos.m_7495_();
        }
        level.m_141902_(pos, ModBlocks.ETERNAL_PEDESTAL_TILE_ENTITY).ifPresent(be -> {
            bool.set(be.interact(state, player, hand, hit));
            if (!level.m_5776_() && bool.get()) {
                be.m_6596_();
            }
        });
        if (bool.get()) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    protected void m_142387_(Level pLevel, Player pPlayer, BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == TripleBlock.UPPER) {
            pos = pos.m_7495_().m_7495_();
        }
        if (state.m_61143_(HALF) == TripleBlock.MIDDLE) {
            pos = pos.m_7495_();
        }
        super.m_142387_(pLevel, pPlayer, pos, pLevel.m_8055_(pos));
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof EternalPedestalTileEntity) {
            CompoundTag stackNBT = blockentity.m_187482_();
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (!stackNBT.m_128456_()) {
                itemStack.m_41700_(BLOCK_ENTITY_TAG, (Tag)stackNBT);
            }
            return List.of(itemStack);
        }
        return super.m_7381_(state, builder);
    }

    public static enum TripleBlock implements StringRepresentable
    {
        UPPER,
        MIDDLE,
        LOWER;


        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this == UPPER ? "upper" : (this == MIDDLE ? "middle" : "lower");
        }
    }
}

