/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class GildedCandelabraBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape GROUNDED_SHAPE = Stream.of(Block.m_49796_((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.m_49796_((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.m_49796_((double)12.0, (double)8.5, (double)6.0, (double)16.0, (double)9.5, (double)10.0), Block.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.m_49796_((double)0.0, (double)8.5, (double)6.0, (double)4.0, (double)9.5, (double)10.0), Block.m_49796_((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.m_49796_((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.m_49796_((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.m_49796_((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.m_49796_((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.m_49796_((double)6.0, (double)10.5, (double)12.0, (double)10.0, (double)11.5, (double)16.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.m_49796_((double)6.0, (double)10.5, (double)0.0, (double)10.0, (double)11.5, (double)4.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.m_49796_((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.m_49796_((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.m_49796_((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape HANGING_SHAPES = Stream.of(Block.m_49796_((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.m_49796_((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.m_49796_((double)12.0, (double)8.5, (double)6.0, (double)16.0, (double)9.5, (double)10.0), Block.m_49796_((double)0.0, (double)8.5, (double)6.0, (double)4.0, (double)9.5, (double)10.0), Block.m_49796_((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.m_49796_((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.m_49796_((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.m_49796_((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.m_49796_((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.m_49796_((double)6.0, (double)10.5, (double)12.0, (double)10.0, (double)11.5, (double)16.0), Block.m_49796_((double)6.0, (double)10.5, (double)0.0, (double)10.0, (double)11.5, (double)4.0), Block.m_49796_((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.m_49796_((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.m_49796_((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.m_49796_((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5), Block.m_49796_((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape GROUNDED_SHAPE_TURNED = Stream.of(Block.m_49796_((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.m_49796_((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.m_49796_((double)6.0, (double)8.5, (double)0.0, (double)10.0, (double)9.5, (double)4.0), Block.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.m_49796_((double)6.0, (double)8.5, (double)12.0, (double)10.0, (double)9.5, (double)16.0), Block.m_49796_((double)7.0, (double)5.5, (double)3.0, (double)9.01, (double)6.5, (double)13.0), Block.m_49796_((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.m_49796_((double)7.0, (double)5.5, (double)1.0, (double)9.0, (double)7.5, (double)3.0), Block.m_49796_((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.m_49796_((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.m_49796_((double)12.0, (double)10.5, (double)6.0, (double)16.0, (double)11.5, (double)10.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.m_49796_((double)0.0, (double)10.5, (double)6.0, (double)4.0, (double)11.5, (double)10.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.m_49796_((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.m_49796_((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.m_49796_((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape HANGING_SHAPES_TURNED = Stream.of(Block.m_49796_((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.m_49796_((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.m_49796_((double)6.0, (double)8.5, (double)0.0, (double)10.0, (double)9.5, (double)4.0), Block.m_49796_((double)6.0, (double)8.5, (double)12.0, (double)10.0, (double)9.5, (double)16.0), Block.m_49796_((double)7.01, (double)5.5, (double)3.0, (double)9.0, (double)6.5, (double)13.0), Block.m_49796_((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)5.5, (double)1.03, (double)9.0, (double)7.5, (double)3.0), Block.m_49796_((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.m_49796_((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.m_49796_((double)12.0, (double)10.5, (double)6.0, (double)16.0, (double)11.5, (double)10.0), Block.m_49796_((double)0.0, (double)10.5, (double)6.0, (double)4.0, (double)11.5, (double)10.0), Block.m_49796_((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.m_49796_((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.m_49796_((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.m_49796_((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5), Block.m_49796_((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public GildedCandelabraBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)LIT, (Comparable)Boolean.FALSE);
        }
        return null;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH || state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH ? (((Boolean)state.m_61143_((Property)HANGING)).booleanValue() ? HANGING_SHAPES : GROUNDED_SHAPE) : ((Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPES_TURNED : GROUNDED_SHAPE_TURNED);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Random random = new Random();
        if (itemstack.m_41720_() == Items.f_42409_ && GildedCandelabraBlock.canBeLit(state)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
            worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(handIn));
            return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public static boolean canBeLit(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) == false;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, HANGING, LIT, WATERLOGGED});
    }

    public static void extinguish(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                GildedCandelabraBlock.spawnSmokeParticles((Level)world, pos, true);
            }
        }
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            boolean flag = (Boolean)state.m_61143_((Property)LIT);
            if (flag) {
                if (!worldIn.m_5776_()) {
                    worldIn.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                GildedCandelabraBlock.extinguish(worldIn, pos, state);
            }
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 3);
            worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public void onProjectileCollision(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!worldIn.f_46443_ && projectile.m_6060_()) {
            boolean flag;
            Entity entity = projectile.m_37282_();
            boolean bl = flag = entity == null || entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entity);
            if (flag && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.m_82425_();
                worldIn.m_7731_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
            }
        }
    }

    public static void spawnSmokeParticles(Level worldIn, BlockPos pos, boolean spawnExtraSmoke) {
        Random random = worldIn.m_5822_();
        SimpleParticleType basicparticletype = ParticleTypes.f_123777_;
        worldIn.m_6493_((ParticleOptions)basicparticletype, true, (double)pos.m_123341_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + random.nextDouble() + random.nextDouble(), (double)pos.m_123343_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isLit(BlockState state) {
        return state.m_61138_((Property)LIT) && (Boolean)state.m_61143_((Property)LIT) != false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = GildedCandelabraBlock.getBlockConnected(state).m_122424_();
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_142300_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11907_, SoundSource.BLOCKS, 0.5f + rand.nextFloat() / 2.0f, rand.nextFloat() * 0.7f + 0.6f);
            }
            if (!((Boolean)state.m_61143_((Property)HANGING)).booleanValue() && rand.nextInt(3) == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0625f), (double)((float)pos.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
            }
            if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST || state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f + 0.375f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f - 0.375f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.875f), (double)((float)pos.m_123343_() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.875f), (double)((float)pos.m_123343_() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
            if (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH || state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f + 0.375f), (double)((float)pos.m_123342_() + 0.875f), (double)((float)pos.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)pos.m_123341_() + 0.5f - 0.375f), (double)((float)pos.m_123342_() + 0.875f), (double)((float)pos.m_123343_() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
        }
    }
}

