/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.entity.HeraldTrophyTileEntity;
import iskallia.vault.block.item.HeraldTrophyItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeraldTrophyBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    public static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public HeraldTrophyBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60999_().m_60913_(5.0f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_(VARIANT, (Comparable)((Object)Variant.BRONZE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{VARIANT});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.HERALD_TROPHY_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        if (!world.f_46443_) {
            CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
            String variantId = blockEntityTag.m_128425_("Variant", 8) ? blockEntityTag.m_128461_("Variant") : Variant.BRONZE.m_7912_();
            Variant variant = Variant.valueOf(variantId.toUpperCase());
            world.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)variant)), 2);
        }
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!world.f_46443_ && !player.m_7500_()) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CompoundTag nbt = itemStack.m_41784_();
            CompoundTag blockEntityTag = itemStack.m_41698_("BlockEntityTag");
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof HeraldTrophyTileEntity) {
                HeraldTrophyTileEntity trophy = (HeraldTrophyTileEntity)tileEntity;
                trophy.writeToEntityTag(blockEntityTag);
            }
            Variant variant = (Variant)((Object)state.m_61143_(VARIANT));
            nbt.m_128405_("CustomModelData", variant.ordinal());
            blockEntityTag.m_128359_("Variant", variant.m_7912_());
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!ModConfigs.isInitialized()) {
            return;
        }
        items.add((Object)HeraldTrophyItem.create(null, Variant.BRONZE, ModConfigs.HERALD_TROPHY.getTime(Variant.BRONZE)));
        items.add((Object)HeraldTrophyItem.create(null, Variant.SILVER, ModConfigs.HERALD_TROPHY.getTime(Variant.SILVER)));
        items.add((Object)HeraldTrophyItem.create(null, Variant.GOLD, ModConfigs.HERALD_TROPHY.getTime(Variant.GOLD)));
        items.add((Object)HeraldTrophyItem.create(null, Variant.PLATINUM, ModConfigs.HERALD_TROPHY.getTime(Variant.PLATINUM)));
    }

    public static enum Variant implements StringRepresentable
    {
        BRONZE,
        SILVER,
        GOLD,
        PLATINUM;

        private static final Map<String, Variant> NAME_TO_TYPE;

        public String getName() {
            return this.name().toLowerCase();
        }

        public static Variant fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase());
        }

        public String m_7912_() {
            return this.getName();
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Variant.values()).collect(Collectors.toMap(Variant::getName, Functions.identity()));
        }
    }
}

