/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.HologramTileEntity;
import iskallia.vault.block.entity.hologram.RootHologramElement;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HologramBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.f_52588_;

    public HologramBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_));
        this.m_49966_().m_61124_(FACING, (Comparable)Direction.SOUTH);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HologramTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.HOLOGRAM_TILE_ENTITY, HologramTileEntity::tick);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_7820_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(world, pos, state, placer, stack);
        if (placer != null && (blockEntity = world.m_7702_(pos)) instanceof HologramTileEntity) {
            HologramTileEntity hologram = (HologramTileEntity)blockEntity;
            hologram.ensureNonNullTree();
            hologram.getTree().iterate(RootHologramElement.class, root -> root.setEulerRotation(new Vec3((double)(360.0f - placer.m_146909_()), (double)placer.m_146908_(), 0.0)));
            hologram.m_6596_();
            world.m_7731_(pos, (BlockState)state.m_61124_(FACING, (Comparable)Direction.SOUTH), 3);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }
}

