/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.IAllowZone;
import iskallia.vault.block.entity.LandmineBlockEntity;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LandmineBlock
extends BaseEntityBlock
implements IAllowZone {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);

    public LandmineBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(0.5f).m_60955_().m_60922_((state, world, pos, type) -> false).m_60924_((state, world, pos) -> false).m_60960_((state, world, pos) -> false).m_60971_((state, world, pos) -> false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && entity instanceof LivingEntity && (blockEntity = world.m_7702_(pos)) instanceof LandmineBlockEntity) {
            LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
            landmine.trigger((LivingEntity)entity);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean moved) {
        if (!level.f_46443_ && neighborPos.equals((Object)pos.m_7495_()) && !level.m_8055_(neighborPos).m_60804_((BlockGetter)level, neighborPos)) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof LandmineBlockEntity) {
                LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
                landmine.expire();
            } else {
                level.m_7471_(pos, false);
            }
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && entity instanceof LivingEntity && (blockEntity = world.m_7702_(pos)) instanceof LandmineBlockEntity) {
            LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
            landmine.trigger((LivingEntity)entity);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = world.m_7702_(pos)) instanceof LandmineBlockEntity) {
            LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
            landmine.onRemoved();
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LandmineBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : LandmineBlock.m_152132_(type, ModBlocks.LANDMINE_TILE_ENTITY, LandmineBlockEntity::tick);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LandmineBlockEntity) {
            LandmineBlockEntity landmine = (LandmineBlockEntity)blockEntity;
            if (landmine.isOwner(player)) {
                return super.m_5880_(state, player, world, pos);
            }
            return super.m_5880_(state, player, world, pos) * 0.1f;
        }
        return super.m_5880_(state, player, world, pos);
    }
}

