/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.MapMarkerBlockEntity;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.WaypointsList;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapMarkerBlock
extends Block
implements EntityBlock {
    public MapMarkerBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MapMarkerBlockEntity) {
            MapMarkerBlockEntity markerBE = (MapMarkerBlockEntity)blockEntity;
            markerBE.setColour(MapMarkerBlockItem.getColour(pStack, 0));
            pLevel.m_7260_(pPos, pState, pState, 4);
        }
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (VaultUtils.isVaultLevel(pLevel) && pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            Vault vault = ServerVaults.get(pLevel).orElse(null);
            if (vault == null) {
                return;
            }
            vault.modifyIfPresent(Vault.MAP_WAYPOINTS, waypoints -> {
                BlockEntity patt2336$temp;
                if (pLevel.m_7702_(pPos) == null || !((patt2336$temp = pLevel.m_7702_(pPos)) instanceof MapMarkerBlockEntity)) {
                    return waypoints;
                }
                MapMarkerBlockEntity be = (MapMarkerBlockEntity)patt2336$temp;
                waypoints.put(pPos, new WaypointsList.Waypoint(be.getColour(), pPlacer.m_142081_()));
                vault.get(Vault.LISTENERS).getAll().forEach(listener -> {
                    Optional<ServerPlayer> playerOpt = listener.getPlayer();
                    playerOpt.ifPresent(p -> {
                        p.m_5661_((Component)player.m_7755_().m_6881_().m_7220_((Component)new TextComponent(" placed a marker")).m_130948_(Style.f_131099_.m_178520_(be.getColour())), true);
                        for (int i = 0; i < 3; ++i) {
                            float pitch = 0.5f + (float)i * 0.1f;
                            ServerScheduler.INSTANCE.schedule(i * 3, () -> p.m_6330_(SoundEvents.f_12210_, SoundSource.BLOCKS, 1.0f, pitch));
                        }
                    });
                });
                return waypoints;
            });
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (VaultUtils.isVaultLevel(level)) {
            Vault vault = ServerVaults.get(level).orElse(null);
            if (vault == null) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            WaypointsList.Waypoint waypoint = (WaypointsList.Waypoint)vault.get(Vault.MAP_WAYPOINTS).get(pos);
            if (waypoint == null) {
                return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
            }
            vault.modifyIfPresent(Vault.MAP_WAYPOINTS, waypoints -> {
                waypoints.remove(pos);
                return waypoints;
            });
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.MARKER_BLOCK);
            MapMarkerBlockItem.setColour(stack, waypoint.getColour());
            MapMarkerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        } else {
            BlockEntity waypoint = level.m_7702_(pos);
            if (waypoint instanceof MapMarkerBlockEntity) {
                MapMarkerBlockEntity be = (MapMarkerBlockEntity)waypoint;
                ItemStack stack = new ItemStack((ItemLike)ModBlocks.MARKER_BLOCK);
                MapMarkerBlockItem.setColour(stack, be.getColour());
                MapMarkerBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MapMarkerBlockEntity(pos, state);
    }

    public static class MapMarkerBlockItem
    extends BlockItem
    implements DyeableLeatherItem {
        public MapMarkerBlockItem(MapMarkerBlock block) {
            super((Block)block, new Item.Properties().m_41486_().m_41491_(ModItems.VAULT_MOD_GROUP));
        }

        public void m_6787_(CreativeModeTab pGroup, NonNullList<ItemStack> pItems) {
            if (this.m_41389_(pGroup)) {
                super.m_6787_(pGroup, pItems);
                for (DyeColor color : DyeColor.values()) {
                    if (color.equals((Object)DyeColor.WHITE)) continue;
                    ItemStack stack = new ItemStack((ItemLike)this);
                    MapMarkerBlockItem.setColour(stack, color.m_41071_());
                    pItems.add((Object)stack);
                }
            }
        }

        public static int getColour(ItemStack stack, int tintIndex) {
            if (tintIndex == 0) {
                if (stack.m_41782_() && stack.m_41784_().m_128441_("display")) {
                    return stack.m_41698_("display").m_128451_("color");
                }
                return 0xFFFFFF;
            }
            return 0xFFFFFF;
        }

        public static void setColour(ItemStack stack, int colour) {
            stack.m_41698_("display").m_128405_("color", colour);
        }

        @NotNull
        public Component m_7626_(ItemStack stack) {
            CompoundTag tag;
            if (stack.m_41782_() && (tag = stack.m_41784_()).m_128441_("display")) {
                return new TextComponent("Map Marker").m_130948_(Style.f_131099_.m_178520_(MapMarkerBlockItem.getColour(stack, 0)));
            }
            return new TextComponent("Map Marker").m_130948_(Style.f_131099_.m_178520_(0xFFFFFF));
        }
    }
}

