/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.PandoraBoxTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PandoraBreakEvent;
import iskallia.vault.core.vault.pandora.PandoraEffect;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PandoraBoxBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public PandoraBoxBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(0.5f, 5.0f).m_60999_());
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.PANDORA_BOX_TILE_ENTITY.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.PANDORA_BOX_TILE_ENTITY, PandoraBoxTileEntity::tick);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        PandoraBoxTileEntity boxTile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PandoraBoxTileEntity && !(boxTile = (PandoraBoxTileEntity)blockEntity).isOpened()) {
            if (!level.m_5776_()) {
                PandoraBreakEvent.Data pandoraEvent = CommonEvents.PANDORA_BREAK.invoke(level, player, pos, boxTile.config);
                level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 0.5f);
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                if (pandoraEvent.getConfig() != null) {
                    Object effect = pandoraEvent.getConfig().build();
                    ((PandoraEffect)effect).execute(level, pos, player);
                }
                boxTile.setOpened(true);
            }
            this.m_5707_(level, pos, state, player);
            return level.m_7731_(pos, fluid.m_76188_(), 11);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

