/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.item.PlaceholderBlockItem;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.CopyToClipboardMessage;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkDirection;

public class PlaceholderBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public PlaceholderBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.WOODEN_CHEST)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_6144_() && !pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            Optional<Vault> serverVaults = ServerVaults.get(pLevel);
            if (serverVaults.isEmpty()) {
                return InteractionResult.PASS;
            }
            Vault vault = serverVaults.get();
            int vaultLevel = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
            long vaultSeed = vault.getOptional(Vault.SEED).orElse(0L);
            vault.ifPresent(Vault.WORLD, worldManager -> {
                ResourceLocation theme = worldManager.get(WorldManager.THEME);
                String themeName = theme != null ? theme.toString() : "none";
                String typeName = ((Type)((Object)((Object)pState.m_61143_(TYPE)))).m_7912_();
                String posName = pPos.m_123344_();
                String message = String.format("Placeholder Type: %s\nVault Theme: %s\nPosition: %s\nVault Seed: %s\nVault Level: %s", typeName, themeName, posName, vaultSeed, vaultLevel);
                pPlayer.m_6352_((Component)new TextComponent("Placeholder info copied to clipboard").m_130940_(ChatFormatting.GREEN).m_130946_("\nPlease report this to the Vault Hunters Official Discord!"), Util.f_137441_);
                ModNetwork.CHANNEL.sendTo((Object)new CopyToClipboardMessage(message), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            });
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Type type;
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (type = Type.fromString(nbt.m_128461_("type"))) != null) {
            blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)type));
        }
        return blockState;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (Type type : Type.values()) {
            items.add((Object)PlaceholderBlockItem.fromType(type));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("type", ((Type)((Object)state.m_61143_(TYPE))).m_7912_());
        return itemStack;
    }

    public static enum Type implements StringRepresentable
    {
        WOODEN_CHEST,
        WOODEN_CHEST_GUARANTEED,
        WOODEN_CHEST_WATERLOGGED,
        GILDED_CHEST,
        GILDED_CHEST_GUARANTEED,
        GILDED_CHEST_WATERLOGGED,
        LIVING_CHEST,
        LIVING_CHEST_GUARANTEED,
        LIVING_CHEST_WATERLOGGED,
        ORNATE_CHEST,
        ORNATE_CHEST_GUARANTEED,
        ORNATE_CHEST_WATERLOGGED,
        OBJECTIVE,
        ORE,
        COIN_STACKS,
        COIN_STACKS_GUARANTEED,
        COIN_STACKS_WATERLOGGED,
        VENDOR_PEDESTAL,
        TREASURE_DOOR,
        DUNGEON_DOOR,
        PYLON,
        DUNGEON_DISCOVERABLE,
        GATE;

        private static final Map<String, Type> NAME_TO_TYPE;

        public static Type fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
        }

        @Nonnull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, Functions.identity()));
        }
    }
}

