/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.PylonTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.UsePylonEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.effect.PylonEffect;
import iskallia.vault.entity.entity.FloatingItemEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.AbsorbingParticleMessage;
import iskallia.vault.skill.prestige.TemporalShardChancePrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerPylons;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class PylonBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0);

    public PylonBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56743_).m_60913_(500.0f, 3600000.0f).m_60999_());
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.PYLON_TILE_ENTITY.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.PYLON_TILE_ENTITY, PylonTileEntity::tick);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        PylonTileEntity pylonTile;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PylonTileEntity && !(pylonTile = (PylonTileEntity)blockEntity).isConsumed()) {
            this.m_5707_(level, pos, state, player);
            return true;
        }
        return false;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        PylonTileEntity pylonTile;
        if (te instanceof PylonTileEntity && !(pylonTile = (PylonTileEntity)te).isConsumed()) {
            pylonTile.setConsumed(true);
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean isUberPylon = pylonTile.config != null && pylonTile.config.getUber();
                Optional<Vault> vault = ServerVaults.get((Level)serverLevel);
                if (vault.isEmpty()) {
                    return;
                }
                if (vault.get().get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
                    return;
                }
                AtomicReference<Float> dropChance = new AtomicReference<Float>(Float.valueOf(isUberPylon ? ModConfigs.TEMPORAL_SHARD.getUberChance() : ModConfigs.TEMPORAL_SHARD.getDropChance()));
                PrestigeHelper.getPrestige(player).getAll(TemporalShardChancePrestigePower.class, temporalShardChancePrestigePower -> temporalShardChancePrestigePower.isUnlocked()).forEach(temporalShardChancePrestigePower -> dropChance.updateAndGet(value -> Float.valueOf(value.floatValue() + temporalShardChancePrestigePower.getChance())));
                CommonEvents.BREAK_PYLON.invoke(level, player, pos);
                if (serverLevel.f_46441_.nextFloat() <= dropChance.get().floatValue()) {
                    ItemStack temporalShard = new ItemStack((ItemLike)ModItems.TEMPORAL_SHARD);
                    FloatingItemEntity floatingItem = FloatingItemEntity.create(level, new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()), temporalShard);
                    floatingItem.setColor(9055202);
                    level.m_7967_((Entity)floatingItem);
                    level.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                }
            }
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        PylonTileEntity pylon;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PylonTileEntity && !(pylon = (PylonTileEntity)blockEntity).isConsumed()) {
            if (!world.f_46443_) {
                UsePylonEvent.Data pylonEvent = CommonEvents.USE_PYLON.invoke(world, player, pos, pylon.config);
                PlayerPylons.add(ServerVaults.get(player.f_19853_).orElse(null), player, pylonEvent.getPylonBuffConfig());
                pylon.setConsumed(true);
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 2.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((Level)world).m_46472_()), (Object)new AbsorbingParticleMessage(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), (Entity)player, pylonEvent.getPylonBuffConfig().getColor()));
                PylonEffect effect = player.m_21023_((MobEffect)ModEffects.PYLON) ? ModEffects.PYLON_OVERFLOW : ModEffects.PYLON;
                effect.setDescription(pylonEvent.getPylonBuffConfig().getDescription());
                Object buff = pylonEvent.getPylonBuffConfig().build();
                Object buffConfig = ((PylonBuff)buff).getConfig();
                int duration = ((PylonBuff.Config)buffConfig).getDuration();
                if (duration > 0) {
                    player.m_7292_(new MobEffectInstance((MobEffect)effect, duration, 60, false, false, true));
                }
                player.m_6352_((Component)new TextComponent("You have used a ").m_7220_((Component)new TextComponent(pylonEvent.getPylonBuffConfig().getDescription()).m_6270_(Style.f_131099_.m_178520_(pylonEvent.getPylonBuffConfig().getColor()))).m_130946_(" Pylon!"), Util.f_137441_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

