/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.RoyaleCrateBlockEntity;
import iskallia.vault.container.inventory.RoyaleCrateInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.tags.ModItemTags;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RoyaleCrateBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<ItemCategory> OPEN_STATE = EnumProperty.m_61587_((String)"open_state", ItemCategory.class);
    public static final String INV_TAG = "Inventory";
    private static final Map<UUID, Object> CRATE_LOCKS = new ConcurrentHashMap<UUID, Object>();

    private static UUID getOrCreateCrateId(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128403_("CrateId")) {
            UUID id = UUID.randomUUID();
            tag.m_128362_("CrateId", id);
            CRATE_LOCKS.putIfAbsent(id, new Object());
            return id;
        }
        UUID id = tag.m_128342_("CrateId");
        CRATE_LOCKS.putIfAbsent(id, new Object());
        return id;
    }

    private static Object getCrateLock(ItemStack stack) {
        return CRATE_LOCKS.get(RoyaleCrateBlock.getOrCreateCrateId(stack));
    }

    public RoyaleCrateBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 3600000.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(OPEN_STATE, (Comparable)((Object)ItemCategory.DECOR)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN_STATE});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        ItemCategory state = (ItemCategory)((Object)pState.m_61143_(OPEN_STATE));
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ItemCategory.DECOR -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case ItemCategory.LOOT_EXCEPT_GEMS -> Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)13.5, (double)14.5);
            case ItemCategory.GEMS -> Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
            case ItemCategory.GEAR_POUCHES -> Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
            case ItemCategory.ROYALE_REWARDS -> Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)9.0, (double)12.0);
        };
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RoyaleCrateBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_() && !world.f_46443_) {
            RoyaleCrateBlockEntity crate = this.getCrateTileEntity(world, pos);
            if (crate == null) {
                return InteractionResult.FAIL;
            }
            ItemCategory currentState = (ItemCategory)((Object)state.m_61143_(OPEN_STATE));
            ItemCategory nextState = currentState == ItemCategory.ROYALE_REWARDS ? null : ItemCategory.values()[(currentState.ordinal() + 1) % ItemCategory.values().length];
            List<OverSizedItemStack> items = crate.getItems().stream().filter(stack -> currentState.getPredicate().test((OverSizedItemStack)stack) && (!currentState.requireNoOtherTags || ItemCategory.getAllPredicates().stream().noneMatch(predicate -> predicate != currentState.getPredicate() && predicate.test(stack)))).toList();
            items.forEach(stack -> {
                if (stack.stack().m_41782_() && stack.stack().m_41783_() != null && stack.stack().m_41783_().m_128441_("VaultRoyaleReward")) {
                    stack.stack().m_41783_().m_128473_("VaultRoyaleReward");
                }
                if (stack.stack().m_41782_() && stack.stack().m_41783_() != null && stack.stack().m_41783_().m_128441_("VaultRoyaleLootable")) {
                    stack.stack().m_41783_().m_128473_("VaultRoyaleLootable");
                }
                stack.splitByStackSize().forEach(split -> RoyaleCrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)split));
                crate.getItems().remove(stack);
            });
            Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
            if (nextState == null) {
                crate.getItems().clear();
                world.m_7471_(pos, false);
                world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.CRATE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            world.m_46597_(pos, (BlockState)state.m_61124_(OPEN_STATE, (Comparable)((Object)nextState)));
            world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.CRATE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
            ((ServerLevel)world).m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 400, 1.0, 1.0, 1.0, 0.5);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_175831_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 50, 1.0, 1.0, 1.0, 0.5);
        }
        return InteractionResult.SUCCESS;
    }

    public static ItemStack getCrateWithLootOversized(NonNullList<OverSizedItemStack> items) {
        ItemStack crate = new ItemStack((ItemLike)ModBlocks.ROYALE_CRATE);
        RoyaleCrateBlock.getOrCreateCrateId(crate);
        CompoundTag nbt = new CompoundTag();
        NBTHelper.writeCollection(nbt, "items", items, CompoundTag.class, OverSizedItemStack::serialize);
        if (!nbt.m_128456_()) {
            crate.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        return crate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addItemToCrate(ItemStack crateStack, OverSizedItemStack item) {
        if (!(crateStack.m_41720_() instanceof CrateItem)) {
            return false;
        }
        Object object = RoyaleCrateBlock.getCrateLock(crateStack);
        synchronized (object) {
            if (!crateStack.m_41782_()) {
                crateStack.m_41751_(new CompoundTag());
            }
            CompoundTag blockEntityTag = crateStack.m_41698_("BlockEntityTag");
            RoyaleCrateInventory inv = new RoyaleCrateInventory();
            inv.load(blockEntityTag);
            inv.addItem(item);
            inv.save(blockEntityTag);
        }
        return true;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof RoyaleCrateBlockEntity) {
            RoyaleCrateBlockEntity crate = (RoyaleCrateBlockEntity)tileentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            CompoundTag compoundnbt = crate.m_187482_();
            if (!compoundnbt.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
            }
            itemstack.m_41700_("OpenState", (Tag)StringTag.m_129297_((String)((ItemCategory)((Object)state.m_61143_(OPEN_STATE))).m_7912_()));
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pStack.m_41782_() && pStack.m_41783_() != null) {
            CompoundTag blockEntityTag = pStack.m_41737_("BlockEntityTag");
            if (pStack.m_41783_().m_128441_("OpenState")) {
                String openState = pStack.m_41783_().m_128461_("OpenState");
                ItemCategory state = ItemCategory.valueOf(openState.toUpperCase());
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_(OPEN_STATE, (Comparable)((Object)state)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addItem(ItemStack stack, ItemStack remainingStack) {
        if (!(stack.m_41720_() instanceof CrateItem)) {
            return false;
        }
        Object object = RoyaleCrateBlock.getCrateLock(stack);
        synchronized (object) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            CompoundTag blockEntityTag = stack.m_41698_("BlockEntityTag");
            RoyaleCrateInventory inv = new RoyaleCrateInventory();
            inv.load(blockEntityTag);
            inv.addItem(OverSizedItemStack.of(remainingStack));
            inv.save(blockEntityTag);
            remainingStack.m_41764_(0);
        }
        return true;
    }

    private RoyaleCrateBlockEntity getCrateTileEntity(Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof RoyaleCrateBlockEntity)) {
            return null;
        }
        RoyaleCrateBlockEntity tile = (RoyaleCrateBlockEntity)blockEntity;
        return tile;
    }

    public static enum ItemCategory implements StringRepresentable
    {
        DECOR(a -> a.stack().m_204117_(ModItemTags.DECOR)),
        LOOT_EXCEPT_GEMS(a -> true, true),
        GEMS(a -> a.stack().m_204117_(ModItemTags.GEMS)),
        GEAR_POUCHES(a -> !(!a.stack().m_204117_(ModItemTags.VAULT_GEAR) && !a.stack().m_204117_(ModItemTags.POUCHES) || a.stack().m_41782_() && a.stack().m_41783_() != null && a.stack().m_41783_().m_128441_("VaultRoyaleReward") && a.stack().m_41783_().m_128471_("VaultRoyaleReward"))),
        ROYALE_REWARDS(a -> a.stack().m_41782_() && a.stack().m_41783_() != null && a.stack().m_41783_().m_128441_("VaultRoyaleReward") && a.stack().m_41783_().m_128471_("VaultRoyaleReward"));

        public final Predicate<OverSizedItemStack> predicate;
        private final boolean requireNoOtherTags;

        private ItemCategory() {
            this(a -> true);
        }

        private ItemCategory(Predicate<OverSizedItemStack> predicate) {
            this(predicate, false);
        }

        private ItemCategory(Predicate<OverSizedItemStack> predicate, boolean requireNoOtherTags) {
            this.predicate = predicate;
            this.requireNoOtherTags = requireNoOtherTags;
        }

        public Predicate<OverSizedItemStack> getPredicate() {
            return this.predicate;
        }

        public static List<Predicate<OverSizedItemStack>> getAllPredicates() {
            return Arrays.stream(ItemCategory.values()).map(ItemCategory::getPredicate).toList();
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }

        public static ItemCategory fromItem(OverSizedItemStack stack) {
            for (ItemCategory category : ItemCategory.values()) {
                if (!category.getPredicate().test(stack)) continue;
                return category;
            }
            return DECOR;
        }

        public static ItemCategory fromItemReverse(OverSizedItemStack stack) {
            for (int i = ItemCategory.values().length - 1; i >= 0; --i) {
                ItemCategory category = ItemCategory.values()[i];
                if (!category.getPredicate().test(stack)) continue;
                return category;
            }
            return DECOR;
        }
    }

    public static class CrateItem
    extends BlockItem {
        public CrateItem(Block pBlock, Item.Properties pProperties) {
            super(pBlock, pProperties);
        }

        public InteractionResult m_6225_(UseOnContext context) {
            Player player = context.m_43723_();
            if (player != null && VaultUtils.isVaultLevel(player.f_19853_)) {
                return InteractionResult.FAIL;
            }
            return super.m_6225_(context);
        }

        public boolean onDroppedByPlayer(ItemStack item, Player player) {
            ServerPlayer sPlayer;
            if (player instanceof ServerPlayer && ServerVaults.get((Level)(sPlayer = (ServerPlayer)player).m_183503_()).isPresent()) {
                return false;
            }
            return super.onDroppedByPlayer(item, player);
        }

        public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
            CompoundTag blockEntityTag;
            if (pStack.m_41782_() && pStack.m_41783_() != null && (blockEntityTag = pStack.m_41737_("BlockEntityTag")) != null && blockEntityTag.m_128441_("items")) {
                NonNullList items = NBTHelper.readCollection(blockEntityTag, "items", CompoundTag.class, OverSizedItemStack::deserialize, NonNullList.m_122779_());
                ItemStack[] stacks = (ItemStack[])items.stream().map(OverSizedItemStack::overSizedStack).toArray(ItemStack[]::new);
                Arrays.sort(stacks, (a, b) -> {
                    ItemCategory catA = ItemCategory.fromItemReverse(OverSizedItemStack.of(a));
                    ItemCategory catB = ItemCategory.fromItemReverse(OverSizedItemStack.of(b));
                    return Integer.compare(catB.ordinal(), catA.ordinal());
                });
                return Optional.of(new Tooltip(stacks));
            }
            return Optional.empty();
        }

        public record Tooltip(ItemStack[] containedStacks) implements TooltipComponent
        {
        }
    }
}

