/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.BossRunePillarTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.integration.IntegrationSB;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.InventoryUtil;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;

public class RunePillarBlock
extends Block
implements EntityBlock {
    private static VoxelShape SHAPE = Stream.of(Block.m_49796_((double)5.5, (double)7.0, (double)11.5, (double)10.5, (double)10.0, (double)12.5), Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)5.0, (double)6.0, (double)4.5, (double)11.0, (double)10.0, (double)11.5), Block.m_49796_((double)4.0, (double)7.0, (double)5.0, (double)12.0, (double)10.0, (double)11.0), Block.m_49796_((double)5.5, (double)7.0, (double)3.5, (double)10.5, (double)10.0, (double)4.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public RunePillarBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76413_).m_60999_().m_60913_(-1.0f, 3600000.0f).m_60955_().m_60953_(state -> 12));
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level level, BlockState state, BlockEntityType<A> blockEntityType) {
        return level.m_5776_() ? BlockHelper.getTicker(blockEntityType, ModBlocks.BOSS_RUNE_PILLAR_TILE_ENTITY, BossRunePillarTileEntity::tickClient) : BlockHelper.getTicker(blockEntityType, ModBlocks.BOSS_RUNE_PILLAR_TILE_ENTITY, BossRunePillarTileEntity::tickServer);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.BOSS_RUNE_PILLAR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BossRunePillarTileEntity)) {
            return InteractionResult.PASS;
        }
        BossRunePillarTileEntity tile = (BossRunePillarTileEntity)blockEntity;
        boolean mainHandEmpty = player.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
        boolean offHandEmpty = player.m_21120_(InteractionHand.OFF_HAND).m_41619_();
        ItemStack existing = tile.getHeldItem().m_41777_();
        if (mainHandEmpty && existing.m_41619_() && tile.getRuneCount() >= tile.getRuneMinimum() && !world.f_46443_ && player.m_6144_() && !tile.consuming) {
            CommonEvents.RUNE_BOSS_START.invoke(world, tile, player);
            return InteractionResult.SUCCESS;
        }
        if (!mainHandEmpty || offHandEmpty) {
            ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (heldItem.m_41720_() instanceof BackpackItem && this.depositBackpackRunes(world, pos, tile, player, InteractionHand.MAIN_HAND)) {
                return InteractionResult.CONSUME;
            }
            if (heldItem.m_41720_() != iskallia.vault.init.ModItems.BOSS_RUNE) {
                return InteractionResult.PASS;
            }
            tile.setHeldItem(heldItem.m_41777_());
            tile.setItemPlacedBy(player.m_142081_());
            player.m_21008_(InteractionHand.MAIN_HAND, existing);
        } else {
            ItemStack heldItem = player.m_21120_(InteractionHand.OFF_HAND);
            if (heldItem.m_41720_() instanceof BackpackItem && this.depositBackpackRunes(world, pos, tile, player, InteractionHand.OFF_HAND)) {
                return InteractionResult.CONSUME;
            }
            if (heldItem.m_41720_() != iskallia.vault.init.ModItems.BOSS_RUNE) {
                return InteractionResult.PASS;
            }
            tile.setHeldItem(heldItem.m_41777_());
            tile.setItemPlacedBy(player.m_142081_());
            player.m_21008_(InteractionHand.OFF_HAND, existing);
        }
        tile.ticksToConsume = 20;
        tile.consuming = false;
        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
        tile.m_6596_();
        world.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
        return InteractionResult.CONSUME;
    }

    private boolean depositBackpackRunes(Level world, BlockPos pos, BossRunePillarTileEntity tile, Player player, InteractionHand hand) {
        ItemStack backpack = player.m_21120_(hand);
        boolean hasDepositUpgrade = backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> {
            UpgradeHandler handler = wrapper.getUpgradeHandler();
            return handler.hasUpgrade(((DepositUpgradeItem)ModItems.DEPOSIT_UPGRADE.get()).getType()) || handler.hasUpgrade(((DepositUpgradeItem)ModItems.ADVANCED_DEPOSIT_UPGRADE.get()).getType());
        }).orElse(false);
        if (!hasDepositUpgrade) {
            return false;
        }
        InventoryUtil.ItemAccess backpackAccess = new InventoryUtil.ItemAccess(backpack, newStack -> player.m_21008_(hand, newStack));
        int deposited = 0;
        for (InventoryUtil.ItemAccess access : IntegrationSB.getBackpackItemAccess(backpackAccess)) {
            ItemStack stack = access.getStack();
            if (stack.m_41720_() != iskallia.vault.init.ModItems.BOSS_RUNE) continue;
            while (!stack.m_41619_()) {
                ItemStack single = stack.m_41620_(1);
                tile.setHeldItem(single);
                tile.setItemPlacedBy(player.m_142081_());
                tile.ticksToConsume = 0;
                tile.consuming = true;
                BossRunePillarTileEntity.tickServer(world, pos, tile.m_58900_(), tile);
                ++deposited;
            }
            access.setStack(stack);
        }
        if (deposited > 0) {
            player.m_21008_(hand, backpackAccess.getStack());
            return true;
        }
        return false;
    }
}

