/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.SkillAltarTileEntity;
import iskallia.vault.container.SkillAltarContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.SkillAltarData;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SkillAltarBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape X_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.375, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.375, (double)0.09375, (double)0.5625, (double)0.96875, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape Z_AXIS_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)1.0, (double)0.375, (double)0.8125), (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.375, (double)0.4375, (double)0.90625, (double)0.96875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);

    public SkillAltarBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SkillAltarTileEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkillAltarTileEntity) {
            SkillAltarTileEntity skillAltarTile = (SkillAltarTileEntity)blockEntity;
            if (placer != null) {
                skillAltarTile.setOwner(placer.m_142081_());
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
            return X_AXIS_SHAPE;
        }
        return Z_AXIS_SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SkillAltarTileEntity) {
                SkillAltarTileEntity skillAltar = (SkillAltarTileEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)skillAltar.getVaultGoldInventory());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof SkillAltarTileEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        SkillAltarBlock.openGui(pos, (ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    private static void openGui(BlockPos pos, ServerPlayer player) {
        SkillAltarBlock.openGui(pos, player, 0, true);
    }

    public static void openGui(BlockPos pos, ServerPlayer player, int templateIndex, boolean defaultGui) {
        player.m_183503_().m_141902_(pos, ModBlocks.SKILL_ALTAR_TILE_ENTITY).ifPresent(skillAltar -> SkillAltarBlock.openGui(pos, player, templateIndex, skillAltar.getOwnerId(), defaultGui));
    }

    private static void openGui(BlockPos pos, ServerPlayer player, int templateIndex, UUID ownerId, boolean defaultGui) {
        SkillAltarData skillAltarData = SkillAltarData.get((ServerLevel)player.f_19853_);
        List<SkillAltarData.SkillIcon> skillIcons = skillAltarData.getSkillTemplates(ownerId).values().stream().map(SkillAltarData.SkillTemplate::getIcon).toList();
        SkillAltarData.SkillTemplate template = skillAltarData.getSkillTemplate(ownerId, templateIndex);
        SkillAltarBlock.networkOpenGui(pos, player, templateIndex, skillIcons, template, defaultGui);
    }

    private static void networkOpenGui(final BlockPos pos, ServerPlayer player, final int templateIndex, final List<SkillAltarData.SkillIcon> skillIcons, final SkillAltarData.SkillTemplate template, final boolean defaultGui) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return ModBlocks.SKILL_ALTAR.m_49954_();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                if (defaultGui) {
                    return new SkillAltarContainer.Default(windowId, inventory, pos, template, templateIndex, skillIcons);
                }
                return new SkillAltarContainer.Import(windowId, inventory, pos, template, templateIndex, skillIcons);
            }
        }, buffer -> {
            buffer.m_130064_(pos);
            SkillAltarData.SkillTemplate.writeTo(template, buffer);
            buffer.writeInt(templateIndex);
            buffer.m_178352_((Collection)skillIcons, (b, icon) -> icon.writeTo((FriendlyByteBuf)b));
        });
    }
}

