/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.entity.entity.FallingSootEntity;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SootLayerBlock
extends FallingBlock {
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[9];

    public SootLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 3223083;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            worldIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext c;
        Entity e;
        if (pContext instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)pContext).m_193113_()) instanceof LivingEntity) {
            return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS) - 1];
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.m_61143_((Property)LAYERS) <= 4;
        }
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos pos = currentPos.m_7494_();
            BlockState state1 = world.m_8055_(pos);
            while (state1.m_60713_((Block)this)) {
                serverLevel.m_186460_(pos, (Block)this, this.m_7198_());
                pos = pos.m_7494_();
                state1 = serverLevel.m_8055_(pos);
            }
        }
        return super.m_7417_(state, direction, facingState, world, currentPos, otherPos);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random pRand) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if ((FallingSootEntity.isSpaceBelow(below) || this.hasIncompleteSootBelow(below)) && pos.m_123342_() >= level.m_141937_()) {
            while (state.m_60713_((Block)this)) {
                FallingSootEntity fallingblockentity = FallingSootEntity.fall((Level)level, pos, state);
                this.m_6788_(fallingblockentity);
                pos = pos.m_7494_();
                state = level.m_8055_(pos);
            }
        }
    }

    private boolean hasIncompleteSootBelow(BlockState state) {
        return state.m_60713_((Block)this) && (Integer)state.m_61143_((Property)LAYERS) != 8;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LAYERS});
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        if (pUseContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            return true;
        }
        return i == 1;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float height) {
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        entity.m_142535_(height, layers > 2 ? 0.3f : 1.0f, DamageSource.f_19315_);
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
    }
}

