/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.SoulPlaqueTileEntity;
import iskallia.vault.block.item.SoulPlaqueBlockItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.BlockHelper;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SoulPlaqueBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty TIER = IntegerProperty.m_61631_((String)"tier", (int)1, (int)8);
    public static VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static VoxelShape WEST_SHAPE = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SoulPlaqueBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.0f, 3600000.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)TIER, (Comparable)Integer.valueOf(1)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TIER});
    }

    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        if (face.m_122434_() == Direction.Axis.Y) {
            face = context.m_8125_().m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.SOUL_PLAQUE_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockHelper.getTicker(pBlockEntityType, ModBlocks.SOUL_PLAQUE_TILE_ENTITY, SoulPlaqueTileEntity::tick);
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @javax.annotation.Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        if (!world.f_46443_) {
            int tier = SoulPlaqueBlockItem.getTier(stack).orElseGet(() -> {
                int score = SoulPlaqueBlockItem.getScore(stack);
                return ModConfigs.ASCENSION.getTier(score);
            });
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TIER, (Comparable)Integer.valueOf(tier)), 2);
        }
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!world.f_46443_ && !player.m_7500_()) {
            ItemStack stack;
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof SoulPlaqueTileEntity) {
                SoulPlaqueTileEntity plaque = (SoulPlaqueTileEntity)tileEntity;
                stack = SoulPlaqueBlockItem.create(plaque.getUuid(), plaque.getSkin().getLatestNickname(), plaque.getScore());
            } else {
                stack = new ItemStack((ItemLike)this);
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!ModConfigs.isInitialized()) {
            return;
        }
        Iterator iterator = ModConfigs.ASCENSION.getScoreToTier().keySet().iterator();
        while (iterator.hasNext()) {
            int score = (Integer)iterator.next();
            items.add((Object)SoulPlaqueBlockItem.create(null, score));
        }
    }
}

