/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.TransmogTableTileEntity;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.model.item.HandHeldModel;
import iskallia.vault.dynamodel.model.item.PlainItemModel;
import iskallia.vault.dynamodel.model.item.shield.ShieldModel;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.util.IskalliaDevs;
import iskallia.vault.www.Reward;
import iskallia.vault.www.RewardsManager;
import iskallia.vault.www.patreon.PatreonManager;
import iskallia.vault.www.patreon.PatreonPlayerData;
import iskallia.vault.www.patreon.PatreonTier;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class TransmogTableBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)});

    public TransmogTableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f).m_60953_(state -> 1).m_60955_());
    }

    public static boolean canTransmogModel(Player player, Collection<ResourceLocation> discoveredModelIds, ResourceLocation modelId) {
        Boolean allowed = TransmogTableBlock.checkModelAccess(player, modelId);
        return allowed != null ? allowed.booleanValue() : discoveredModelIds.contains(modelId);
    }

    @Nullable
    private static Boolean checkModelAccess(Player player, ResourceLocation modelId) {
        PatreonPlayerData data = PatreonManager.getInstance().getPlayerData(player.m_142081_());
        Reward rewards = RewardsManager.getInstance().getRewardData(player.m_142081_());
        Optional armorPiece = ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId);
        if (armorPiece.isPresent()) {
            ArmorModel armorModel = ((ArmorPieceModel)armorPiece.get()).getArmorModel();
            if (armorModel.getModelProperties().doesRequire()) {
                return armorModel.getModelProperties().canObtain(player.m_142081_());
            }
            if (armorModel.equals(ModDynamicModels.Armor.CHAMPION)) {
                return data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            if (armorModel.equals(ModDynamicModels.Armor.GOBLIN)) {
                return data.isAtLeastTier(PatreonTier.GOBLIN);
            }
            if (armorModel.equals(ModDynamicModels.Armor.CHEESE_WARRIOR)) {
                return data.isAtLeastTier(PatreonTier.CHEESER);
            }
            if (armorModel.equals(ModDynamicModels.Armor.DEVELOPER_SET)) {
                return IskalliaDevs.isDeveloper(player.m_142081_());
            }
            if (armorModel.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.ARMOR, armorModel.getId());
            }
            return null;
        }
        Optional<HandHeldModel> sword = ModDynamicModels.Swords.REGISTRY.get(modelId);
        if (sword.isPresent()) {
            HandHeldModel model = sword.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.equals(ModDynamicModels.Swords.GODSWORD)) {
                return IskalliaDevs.isDeveloper(player.m_142081_()) || data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            if (model.equals(ModDynamicModels.Swords.DWELLER_SWORD)) {
                return IskalliaDevs.isDeveloper(player.m_142081_()) || data.isAtLeastTier(PatreonTier.DWELLER);
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.SWORD, model.getId());
            }
            return null;
        }
        Optional<HandHeldModel> axe = ModDynamicModels.Axes.REGISTRY.get(modelId);
        if (axe.isPresent()) {
            HandHeldModel model = axe.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.equals(ModDynamicModels.Axes.GODAXE)) {
                return data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            if (model.equals(ModDynamicModels.Axes.DWELLER_AXE)) {
                return data.isAtLeastTier(PatreonTier.DWELLER);
            }
            if (model.equals(ModDynamicModels.Axes.DEVELOPER_DUCKY)) {
                return IskalliaDevs.isDeveloper(player.m_142081_());
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.AXE, model.getId());
            }
            return null;
        }
        Optional<PlainItemModel> focus = ModDynamicModels.Focus.REGISTRY.get(modelId);
        if (focus.isPresent()) {
            PlainItemModel model = focus.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.FOCUS, model.getId());
            }
            if (model.equals(ModDynamicModels.Focus.JAVA_MUG)) {
                return IskalliaDevs.isDeveloper(player.m_142081_());
            }
            return null;
        }
        Optional<PlainItemModel> wand = ModDynamicModels.Wands.REGISTRY.get(modelId);
        if (wand.isPresent()) {
            PlainItemModel model = wand.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.WAND, model.getId());
            }
            if (model.equals(ModDynamicModels.Wands.DEVELOPER_BACKSCRATCHER)) {
                return IskalliaDevs.isDeveloper(player.m_142081_());
            }
            return null;
        }
        Optional<ShieldModel> shield = ModDynamicModels.Shields.REGISTRY.get(modelId);
        if (shield.isPresent()) {
            ShieldModel model = shield.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.SHIELD, model.getId());
            }
            return null;
        }
        Optional<PlainItemModel> magnet = ModDynamicModels.Magnets.REGISTRY.get(modelId);
        if (magnet.isPresent()) {
            PlainItemModel model = magnet.get();
            if (model.getModelProperties().doesRequire()) {
                return model.getModelProperties().canObtain(player.m_142081_());
            }
            if (model.getModelProperties().doesRequireRewards()) {
                if (IskalliaDevs.isDeveloper(player.m_142081_())) {
                    return true;
                }
                return rewards.hasModel(Reward.ArmorPiece.MAGNET, model.getId());
            }
            return null;
        }
        return null;
    }

    private static long hashId(UUID id) {
        return id.getMostSignificantBits() ^ id.getLeastSignificantBits();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TransmogTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        TransmogTableTileEntity transmogTableTileEntity = (TransmogTableTileEntity)tile;
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)transmogTableTileEntity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60780_((BlockGetter)reader, (BlockPos)pos).f_76396_;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.TRANSMOG_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof TransmogTableTileEntity) {
                TransmogTableTileEntity transmogTableTileEntity = (TransmogTableTileEntity)blockentity;
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)transmogTableTileEntity.getInternalInventory());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }
}

