/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.entity.TreasureDoorTileEntity;
import iskallia.vault.block.item.TreasureDoorBlockItem;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultKeyring;
import iskallia.vault.util.BlockHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class TreasureDoorBlock
extends DoorBlock
implements EntityBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public TreasureDoorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76367_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(TYPE, (Comparable)((Object)Type.ISKALLIUM)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.TREASURE_DOOR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockHelper.getTicker(pBlockEntityType, ModBlocks.TREASURE_DOOR_TILE_ENTITY, TreasureDoorTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Boolean isOpen = (Boolean)state.m_61143_((Property)f_52727_);
        if (!isOpen.booleanValue() && this.consumeKey(player, hand, (Type)((Object)state.m_61143_(TYPE)))) {
            this.m_153165_((Entity)player, world, state, pos, true);
            if (!world.m_5776_()) {
                CommonEvents.TREASURE_ROOM_OPEN.invoke(world, player, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean consumeKey(Player player, InteractionHand hand, Type doorType) {
        List<OverSizedItemStack> stored;
        OverSizedItemStack keyStack;
        Item requiredKey;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_150930_(requiredKey = doorType.getKey())) {
            if (!player.m_7500_()) {
                heldStack.m_41774_(1);
            }
            return true;
        }
        if (heldStack.m_150930_((Item)ModItems.TREAUSURE_KEYRING) && !(keyStack = (stored = ItemVaultKeyring.getStoredStacks(heldStack)).stream().filter(stack -> stack.stack().m_150930_(requiredKey)).findFirst().orElse(OverSizedItemStack.EMPTY)).isEmpty()) {
            if (!player.m_7500_()) {
                int newAmount = keyStack.amount() - 1;
                stored.remove(keyStack);
                if (newAmount > 0) {
                    stored.add(OverSizedItemStack.of(new ItemStack((ItemLike)requiredKey, newAmount)));
                }
                ItemVaultKeyring.setStoredStacks(heldStack, stored);
            }
            return true;
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Type type;
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (type = Type.fromString(nbt.m_128461_("type"))) != null) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        return state;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (Type type : Type.values()) {
            items.add((Object)TreasureDoorBlockItem.fromType(type));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("type", ((Type)((Object)state.m_61143_(TYPE))).m_7912_());
        return itemStack;
    }

    public static enum Type implements StringRepresentable
    {
        ISKALLIUM(ModItems.ISKALLIUM_KEY),
        GORGINITE(ModItems.GORGINITE_KEY),
        SPARKLETINE(ModItems.SPARKLETINE_KEY),
        ASHIUM(ModItems.ASHIUM_KEY),
        BOMIGNITE(ModItems.BOMIGNITE_KEY),
        TUBIUM(ModItems.TUBIUM_KEY),
        UPALINE(ModItems.UPALINE_KEY),
        PUFFIUM(ModItems.PUFFIUM_KEY),
        PETZANITE(ModItems.PETZANITE_KEY),
        XENIUM(ModItems.XENIUM_KEY);

        private static final Map<String, Type> NAME_TO_TYPE;
        private final Item key;

        private Type(Item key) {
            this.key = key;
        }

        public static Type fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
        }

        public Item getKey() {
            return this.key;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, Functions.identity()));
        }
    }
}

