/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.TreasurePedestalTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TreasurePedestalBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public TreasurePedestalBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76366_).m_60955_().m_60913_(2.0f, 6.0f));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level world, BlockState state, BlockEntityType<A> type) {
        return BlockHelper.getTicker(type, ModBlocks.TREASURE_PEDESTAL_TILE_ENTITY, TreasurePedestalTileEntity::tick);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof TreasurePedestalTileEntity)) {
            return;
        }
        TreasurePedestalTileEntity pedestal = (TreasurePedestalTileEntity)tile;
        if (!level.m_5776_() && pedestal.isVaultPedestal()) {
            this.breakPedestal(state, level, pos);
        } else {
            super.m_6256_(state, level, pos, player);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof TreasurePedestalTileEntity)) {
            return InteractionResult.PASS;
        }
        TreasurePedestalTileEntity pedestal = (TreasurePedestalTileEntity)tile;
        if (pedestal.isVaultPedestal()) {
            this.breakPedestal(state, level, pos);
            return InteractionResult.SUCCESS;
        }
        if (pedestal.getContained().m_41619_() && !player.m_21120_(hand).m_41619_()) {
            ItemStack o = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!o.m_41619_()) {
                ItemStack insert = o.m_41777_();
                insert.m_41764_(1);
                if (!player.m_150110_().f_35937_) {
                    o.m_41774_(1);
                }
                pedestal.setContained(insert);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        } else if (!pedestal.getContained().m_41619_()) {
            ItemStack itemStack = pedestal.getContained();
            pedestal.setContained(ItemStack.f_41583_);
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, itemStack);
            } else {
                boolean added = player.m_150109_().m_36054_(itemStack);
                if (!added) {
                    TreasurePedestalBlock.m_49840_((Level)level, (BlockPos)pos.m_7494_(), (ItemStack)itemStack);
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TreasurePedestalTileEntity)) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        TreasurePedestalTileEntity pedestal = (TreasurePedestalTileEntity)blockEntity;
        if (!pedestal.isVaultPedestal()) {
            ItemStack itemStack = pedestal.getContained();
            if (!itemStack.m_41619_()) {
                TreasurePedestalBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
                pedestal.setContained(ItemStack.f_41583_);
            }
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void breakPedestal(BlockState state, Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)level;
        BlockEntity tile = sWorld.m_7702_(pos);
        if (!(tile instanceof TreasurePedestalTileEntity)) {
            return;
        }
        TreasurePedestalTileEntity pedestal = (TreasurePedestalTileEntity)tile;
        if (!pedestal.getContained().m_41619_()) {
            TreasurePedestalBlock.m_49840_((Level)sWorld, (BlockPos)pos, (ItemStack)pedestal.getContained());
            pedestal.setContained(ItemStack.f_41583_);
        }
        if (!pedestal.isVaultPedestal()) {
            return;
        }
        Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
        sWorld.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.CRATE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        sWorld.m_7471_(pos, false);
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
        sWorld.m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 300, 1.0, 1.0, 1.0, 0.5);
        this.removeOtherPedestals(sWorld, pos);
    }

    private void removeOtherPedestals(ServerLevel level, BlockPos clickedPos) {
        BlockPos checkPos;
        int i;
        ArrayList<BlockPos> allPedestals = new ArrayList<BlockPos>();
        allPedestals.add(clickedPos);
        for (i = 1; i <= 6; ++i) {
            checkPos = clickedPos.m_142082_(i, 0, 0);
            if (!this.isPedestalAt((Level)level, checkPos)) continue;
            allPedestals.add(checkPos);
        }
        for (i = 1; i <= 6; ++i) {
            checkPos = clickedPos.m_142082_(-i, 0, 0);
            if (!this.isPedestalAt((Level)level, checkPos)) continue;
            allPedestals.add(checkPos);
        }
        if (allPedestals.size() == 3) {
            this.removePedestals(level, allPedestals, clickedPos);
            return;
        }
        allPedestals.clear();
        allPedestals.add(clickedPos);
        for (i = 1; i <= 6; ++i) {
            checkPos = clickedPos.m_142082_(0, 0, i);
            if (!this.isPedestalAt((Level)level, checkPos)) continue;
            allPedestals.add(checkPos);
        }
        for (i = 1; i <= 6; ++i) {
            checkPos = clickedPos.m_142082_(0, 0, -i);
            if (!this.isPedestalAt((Level)level, checkPos)) continue;
            allPedestals.add(checkPos);
        }
        if (allPedestals.size() == 3) {
            this.removePedestals(level, allPedestals, clickedPos);
        }
    }

    private void removePedestals(ServerLevel level, List<BlockPos> pedestals, BlockPos clickedPos) {
        for (BlockPos pedPos : pedestals) {
            TreasurePedestalTileEntity otherPedestal;
            if (pedPos.equals((Object)clickedPos)) continue;
            BlockEntity blockEntity = level.m_7702_(pedPos);
            if (blockEntity instanceof TreasurePedestalTileEntity && !(otherPedestal = (TreasurePedestalTileEntity)blockEntity).getContained().m_41619_()) {
                otherPedestal.setContained(ItemStack.f_41583_);
            }
            level.m_7471_(pedPos, false);
        }
    }

    private boolean isPedestalAt(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof TreasurePedestalBlock;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.TREASURE_PEDESTAL_TILE_ENTITY.m_155264_(pPos, pState);
    }
}

