/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.property.HiddenIntegerProperty;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.MathUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultArtifactBlock
extends FacedBlock {
    public static final int ARTIFACT_COUNT = 25;
    public static final IntegerProperty ORDER_PROPERTY = HiddenIntegerProperty.create("order", 1, 25);
    public static final BooleanProperty GRAYSCALE = BooleanProperty.m_61465_((String)"grayscale");
    public static final VoxelShape EAST_SHAPE = Block.m_49796_((double)15.75, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.25);
    public static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.75, (double)16.0, (double)16.0, (double)16.0);

    public VaultArtifactBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56745_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)GRAYSCALE, (Comparable)Boolean.valueOf(false)));
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    public int getOrder(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128441_("CustomModelData") ? nbt.m_128451_("CustomModelData") : 1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST_SHAPE;
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> SOUTH_SHAPE;
        };
    }

    @Override
    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack artifactBlockItem = context.m_43722_();
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)ORDER_PROPERTY, (Comparable)Integer.valueOf(this.getOrder(artifactBlockItem)))).m_61124_((Property)GRAYSCALE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ORDER_PROPERTY, GRAYSCALE});
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public static List<BlockPos> isValidArtifactSetup(ServerLevel world, BlockPos at, BlockState state) {
        int order = (25 - (Integer)state.m_61143_((Property)ORDER_PROPERTY) + 24) % 25;
        int shiftVertical = order / 5;
        int shiftHorizontal = order % 5;
        BlockPos yPos = at.m_6630_(shiftVertical);
        for (Direction dir : Direction.values()) {
            BlockPos startPos;
            List<BlockPos> artifactPositions;
            if (dir.m_122434_().m_122478_() || (artifactPositions = VaultArtifactBlock.hasFullArtifactSet(world, startPos = yPos.m_5484_(dir, -shiftHorizontal), dir)).isEmpty()) continue;
            return artifactPositions;
        }
        return Collections.emptyList();
    }

    private static List<BlockPos> hasFullArtifactSet(ServerLevel world, BlockPos start, Direction facing) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int order = 0; order < 25; ++order) {
            BlockPos at = start.m_6625_(order / 5).m_5484_(facing, order % 5);
            BlockState offsetState = world.m_8055_(at);
            if (!(offsetState.m_60734_() instanceof VaultArtifactBlock)) {
                return Collections.emptyList();
            }
            int orderAt = (25 - (Integer)offsetState.m_61143_((Property)ORDER_PROPERTY) + 24) % 25;
            if (order != orderAt) {
                return Collections.emptyList();
            }
            positions.add(at);
        }
        return positions;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Integer order = (Integer)state.m_61143_((Property)ORDER_PROPERTY);
        ItemStack artifactStack = VaultArtifactBlock.createArtifact(order);
        return new ArrayList<ItemStack>(Collections.singletonList(artifactStack));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Integer order = (Integer)state.m_61143_((Property)ORDER_PROPERTY);
        return VaultArtifactBlock.createArtifact(order);
    }

    public static int getArtifactOrder(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return nbt.m_128441_("CustomModelData") ? nbt.m_128451_("CustomModelData") : 1;
    }

    public static ItemStack createRandomArtifact() {
        return VaultArtifactBlock.createArtifact(MathUtilities.getRandomInt(0, 25) + 1);
    }

    public static ItemStack createArtifact(int order) {
        Item artifactItem = (Item)ForgeRegistries.ITEMS.getValue(ModBlocks.VAULT_ARTIFACT.getRegistryName());
        ItemStack itemStack = new ItemStack((ItemLike)artifactItem, 1);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("CustomModelData", Mth.m_14045_((int)order, (int)0, (int)25));
        itemStack.m_41751_(nbt);
        return itemStack;
    }
}

