/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.mojang.math.Vector3f;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultBarrelBlock
extends VaultChestBlock {
    public static final DirectionProperty DIRECTION = DirectionProperty.m_61549_((String)"direction", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public VaultBarrelBlock(VaultChestType type, boolean locked, boolean dynamicRenderer, BlockBehaviour.Properties builder) {
        super(type, locked, dynamicRenderer, builder.m_60955_(), () -> ModBlocks.VAULT_CHEST_TILE_ENTITY);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.UP)).m_61124_((Property)f_51478_, (Comparable)Direction.NORTH)).m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DIRECTION});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    @Override
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return true;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state != null ? (BlockState)state.m_61124_((Property)DIRECTION, (Comparable)context.m_7820_().m_122424_()) : null;
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, LootContext.Builder builder) {
        VaultChestTileEntity barrel;
        BlockEntity blockEntity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockEntity instanceof VaultChestTileEntity && !(barrel = (VaultChestTileEntity)blockEntity).isVaultChest()) {
            builder = builder.m_78979_(CONTENTS, (p_56218_, p_56219_) -> {
                for (int index = 0; index < barrel.m_6643_(); ++index) {
                    p_56219_.accept(barrel.m_8020_(index));
                }
            });
        }
        return super.m_7381_(state, builder);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof VaultChestTileEntity) {
                VaultChestTileEntity entity = (VaultChestTileEntity)blockEntity;
                if (!entity.isVaultChest()) {
                    level.m_46717_(pos, state.m_60734_());
                    if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
                        level.m_46747_(pos);
                    }
                } else {
                    float blue;
                    float green;
                    float red;
                    SoundEvent soundToPlay;
                    int itemCount = this.countNonEmptySlots(entity);
                    if (itemCount == 1) {
                        soundToPlay = ModSounds.DUNGEON_BARREL_BREAK_EXTRA;
                        red = 1.0f;
                        green = 1.0f;
                        blue = 0.0f;
                    } else if (itemCount == 2) {
                        soundToPlay = ModSounds.DUNGEON_BARREL_BREAK_EXTRA;
                        red = 1.0f;
                        green = 0.5f;
                        blue = 0.0f;
                    } else if (itemCount > 2) {
                        soundToPlay = ModSounds.DUNGEON_BARREL_BREAK_EVEN_MORE;
                        red = 1.0f;
                        green = 0.0f;
                        blue = 0.0f;
                    } else {
                        soundToPlay = ModSounds.DUNGEON_BARREL_BREAK_NORMAL;
                        red = 0.7f;
                        green = 0.7f;
                        blue = 0.7f;
                    }
                    level.m_5594_(null, pos, soundToPlay, SoundSource.BLOCKS, 0.3f, 0.8f + level.f_46441_.nextFloat() * 0.4f);
                    this.spawnBreakParticles(level, pos, red, green, blue, itemCount);
                    super.m_6810_(state, level, pos, newState, isMoving);
                }
            } else {
                super.m_6810_(state, level, pos, newState, isMoving);
            }
        }
    }

    private void spawnBreakParticles(Level level, BlockPos pos, float red, float green, float blue, int itemCount) {
        if (level.f_46443_) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int particleCount = 5 + Math.min(itemCount * 3, 20);
        for (int i = 0; i < particleCount; ++i) {
            double offsetX = level.f_46441_.nextDouble() * 0.8 - 0.4;
            double offsetY = level.f_46441_.nextDouble() * 0.8 - 0.4;
            double offsetZ = level.f_46441_.nextDouble() * 0.8 - 0.4;
            double particleX = (double)pos.m_123341_() + 0.5 + offsetX;
            double particleY = (double)pos.m_123342_() + 0.5 + offsetY;
            double particleZ = (double)pos.m_123343_() + 0.5 + offsetZ;
            serverLevel.m_8767_((ParticleOptions)new ColoredParticleOptions((ParticleType<ColoredParticleOptions>)((ParticleType)ModParticles.TOTEM_FOUNTAIN.get()), new Vector3f(red, green, blue)), particleX, particleY, particleZ, 1, 0.05, 0.05, 0.05, 0.0);
        }
    }

    private int countNonEmptySlots(VaultChestTileEntity entity) {
        int count = 0;
        for (int i = 0; i < entity.m_6643_(); ++i) {
            if (entity.m_8020_(i).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter blockGetter, @NotNull List<Component> toolTip, @NotNull TooltipFlag flag) {
        super.m_5871_(stack, blockGetter, toolTip, flag);
        CompoundTag entityData = BlockItem.m_186336_((ItemStack)stack);
        if (entityData != null && entityData.m_128425_("Items", 9)) {
            NonNullList items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)entityData, (NonNullList)items);
            int unique = 0;
            int index = 0;
            for (ItemStack itemStack : items) {
                if (itemStack.m_41619_()) continue;
                ++index;
                if (unique > 4) continue;
                ++unique;
                MutableComponent component = itemStack.m_41786_().m_6881_();
                component.m_130946_(" x").m_130946_(String.valueOf(itemStack.m_41613_()));
                toolTip.add((Component)component);
            }
            if (index - unique > 0) {
                toolTip.add((Component)new TranslatableComponent("container.the_vault.barrel.more", new Object[]{index - unique}).m_130940_(ChatFormatting.ITALIC));
            }
        }
    }
}

