/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.VaultBarrelBlock;
import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.container.inventory.VaultBarrelContainer;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class VaultChestBlock
extends ChestBlock {
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);
    private final VaultChestType type;
    private final boolean locked;
    private final boolean dynamicRenderer;

    protected VaultChestBlock(VaultChestType type, boolean locked, boolean dynamicRenderer, BlockBehaviour.Properties builder, Supplier<BlockEntityType<? extends ChestBlockEntity>> tileSupplier) {
        super(builder, tileSupplier);
        this.type = type;
        this.locked = locked;
        this.dynamicRenderer = dynamicRenderer;
    }

    public VaultChestBlock(VaultChestType type, boolean locked, boolean dynamicRenderer, BlockBehaviour.Properties builder) {
        this(type, locked, dynamicRenderer, builder, () -> ModBlocks.VAULT_CHEST_TILE_ENTITY);
    }

    public VaultChestBlock(VaultChestType type, BlockBehaviour.Properties builder) {
        this(type, false, true, builder, () -> ModBlocks.VAULT_CHEST_TILE_ENTITY);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    public boolean hasDynamicRenderer() {
        return this.dynamicRenderer;
    }

    public VaultChestType getType() {
        return this.type;
    }

    public boolean hasStepBreaking(VaultChestTileEntity tileEntity) {
        return tileEntity.isVaultChest() && (this == ModBlocks.GILDED_CHEST || this == ModBlocks.LIVING_CHEST || this == ModBlocks.ORNATE_CHEST || this == ModBlocks.FLESH_CHEST || this == ModBlocks.ENIGMA_CHEST);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public InteractionResult m_6227_(BlockState pState, Level level, BlockPos pos, Player player, InteractionHand pHand, BlockHitResult pHit) {
        VaultChestTileEntity entity;
        BlockEntity blockEntity;
        if (this.isLocked() && !player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof VaultChestTileEntity && (entity = (VaultChestTileEntity)blockEntity).isVaultChest()) {
            return InteractionResult.FAIL;
        }
        return super.m_6227_(pState, level, pos, player, pHand, pHit);
    }

    @javax.annotation.Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level pLevel, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.VAULT_CHEST_TILE_ENTITY, pLevel.f_46443_ ? VaultChestTileEntity::tick : null);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        VaultChestTileEntity chest;
        block6: {
            block5: {
                BlockEntity te = world.m_7702_(pos);
                if (!(te instanceof VaultChestTileEntity)) break block5;
                chest = (VaultChestTileEntity)te;
                if (!player.m_7500_()) break block6;
            }
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (!this.hasStepBreaking(chest)) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (chest.m_7983_()) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        this.m_5707_(world, pos, state, player);
        return true;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        if (!(te instanceof VaultChestTileEntity)) {
            super.m_6240_(world, player, pos, state, te, stack);
            return;
        }
        VaultChestTileEntity chestTileEntity = (VaultChestTileEntity)te;
        if (!this.hasStepBreaking(chestTileEntity)) {
            super.m_6240_(world, player, pos, state, te, stack);
            return;
        }
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        if (te instanceof VaultChestTileEntity) {
            VaultChestTileEntity chest = (VaultChestTileEntity)te;
            for (int slot = 0; slot < chest.m_6643_(); ++slot) {
                ItemStack invStack = chest.m_8020_(slot);
                if (invStack.m_41619_()) continue;
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)invStack);
                chest.m_6836_(slot, ItemStack.f_41583_);
                break;
            }
        }
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new VaultChestTileEntity(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)((BlockState)state.m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE)).m_61124_(VARIANT, (Comparable)((Object)Variant.NORMAL));
    }

    @javax.annotation.Nullable
    public MenuProvider m_7246_(final BlockState state, Level level, BlockPos pos) {
        VaultChestTileEntity tileEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VaultChestTileEntity && !(tileEntity = (VaultChestTileEntity)blockEntity).isVaultChest()) {
            return new MenuProvider(){

                public Component m_5446_() {
                    return tileEntity.m_5446_();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                    if (tileEntity.m_7525_(player)) {
                        MenuType menuType = switch (tileEntity.m_6643_()) {
                            case 36 -> MenuType.f_39960_;
                            case 45 -> MenuType.f_39961_;
                            case 54 -> MenuType.f_39962_;
                            default -> MenuType.f_39959_;
                        };
                        int rows = tileEntity.m_6643_() / 9;
                        Block block = state.m_60734_();
                        if (block instanceof VaultBarrelBlock) {
                            VaultBarrelBlock barrelBlock = (VaultBarrelBlock)block;
                            return new VaultBarrelContainer(menuType, i, inventory, (Container)tileEntity, rows);
                        }
                        return new ChestMenu(menuType, i, inventory, (Container)tileEntity, rows);
                    }
                    return null;
                }
            };
        }
        if ((state.m_60734_() == ModBlocks.ALTAR_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.GILDED_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.LIVING_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.ORNATE_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.HARDENED_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.FLESH_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.ENIGMA_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.TREASURE_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.WOODEN_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.ORNATE_STRONGBOX || state.m_60734_() == ModBlocks.GILDED_STRONGBOX || state.m_60734_() == ModBlocks.LIVING_STRONGBOX) && (blockEntity = level.m_7702_(pos)) instanceof VaultChestTileEntity) {
            final VaultChestTileEntity te = (VaultChestTileEntity)blockEntity;
            te.setHidden(true);
            return new MenuProvider(){

                public Component m_5446_() {
                    return te.m_5446_();
                }

                @javax.annotation.Nullable
                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    if (te.m_7525_(player)) {
                        switch (te.m_6643_()) {
                            case 36: {
                                return new ChestMenu(MenuType.f_39960_, containerId, playerInventory, (Container)te, 4);
                            }
                            case 45: {
                                return new ChestMenu(MenuType.f_39961_, containerId, playerInventory, (Container)te, 5);
                            }
                            case 54: {
                                return new ChestMenu(MenuType.f_39962_, containerId, playerInventory, (Container)te, 6);
                            }
                        }
                        return new ChestMenu(MenuType.f_39959_, containerId, playerInventory, (Container)te, 3);
                    }
                    return null;
                }
            };
        }
        if (this == ModBlocks.TREASURE_CHEST && (blockEntity = level.m_7702_(pos)) instanceof ChestBlockEntity) {
            final ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            return new MenuProvider(){

                public Component m_5446_() {
                    return chest.m_5446_();
                }

                @javax.annotation.Nullable
                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    if (chest.m_7525_(player)) {
                        chest.m_59640_(player);
                        return ChestMenu.m_39246_((int)containerId, (Inventory)playerInventory, (Container)chest);
                    }
                    return null;
                }
            };
        }
        return super.m_7246_(state, level, pos);
    }

    public RenderShape m_7514_(BlockState pState) {
        return this.dynamicRenderer ? RenderShape.ENTITYBLOCK_ANIMATED : RenderShape.MODEL;
    }

    public static enum Variant implements StringRepresentable
    {
        NORMAL("normal"),
        PRESENT("present");

        private final String serializedName;

        private Variant(String serializedName) {
            this.serializedName = serializedName;
        }

        @Nonnull
        public String m_7912_() {
            return this.serializedName;
        }
    }
}

