/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.antique.Antique;
import iskallia.vault.antique.AntiqueRegistry;
import iskallia.vault.antique.condition.DropConditionContext;
import iskallia.vault.antique.condition.DropConditionContextFactory;
import iskallia.vault.block.entity.VaultCrateTileEntity;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.AntiqueItem;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VaultCrateBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = DirectionProperty.m_61546_((String)"horizontal_facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VaultCrateBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(2.0f, 3600000.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public static Stream<Antique> generateCrateAntiques(Type type, int level) {
        return VaultCrateBlock.generateCrateAntiques(type, level, null);
    }

    public static Stream<Antique> generateCrateAntiques(Type type, int level, @javax.annotation.Nullable ServerPlayer player) {
        DropConditionContext ctx = DropConditionContextFactory.makeRewardCrate(level, VaultCrateBlock.getCrateBlock(type), player);
        return AntiqueRegistry.getAntiquesMatchingCondition(ctx);
    }

    public static ItemStack getCrateWithLootWithAntiques(Type type, int level, NonNullList<ItemStack> items) {
        return VaultCrateBlock.getCrateWithLootWithAntiques(type, level, items, null);
    }

    public static ItemStack getCrateWithLootWithAntiques(Type type, int level, NonNullList<ItemStack> items, @javax.annotation.Nullable ServerPlayer player) {
        VaultCrateBlock.generateCrateAntiques(type, level, player).forEach(antique -> items.add((Object)AntiqueItem.createStack(antique)));
        return VaultCrateBlock.getCrateWithLoot(type, items);
    }

    public static ItemStack getCrateWithLoot(Type type, NonNullList<ItemStack> items) {
        NonNullList oversizedItems = NonNullList.m_122779_();
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            oversizedItems.add((Object)OverSizedItemStack.of(stack.m_41777_()));
        }
        return VaultCrateBlock.getCrateWithLootOversized(type, (NonNullList<OverSizedItemStack>)oversizedItems);
    }

    public static Block getCrateBlock(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BOSS -> ModBlocks.VAULT_CRATE;
            case Type.SCAVENGER -> ModBlocks.VAULT_CRATE_SCAVENGER;
            case Type.CAKE -> ModBlocks.VAULT_CRATE_CAKE;
            case Type.ARENA -> ModBlocks.VAULT_CRATE_ARENA;
            case Type.CHAMPION -> ModBlocks.VAULT_CRATE_CHAMPION;
            case Type.BOUNTY -> ModBlocks.VAULT_CRATE_BOUNTY;
            case Type.MONOLITH -> ModBlocks.VAULT_CRATE_MONOLITH;
            case Type.ELIXIR -> ModBlocks.VAULT_CRATE_ELIXIR;
            case Type.PARADOX -> ModBlocks.VAULT_CRATE_PARADOX;
            case Type.BINGO -> ModBlocks.VAULT_CRATE_BINGO;
            case Type.RUNE_BOSS -> ModBlocks.VAULT_CRATE_RUNE_BOSS;
            case Type.GREED -> ModBlocks.VAULT_CRATE_GREED;
        };
    }

    public static ItemStack getCrateWithLootOversized(Type type, NonNullList<OverSizedItemStack> items) {
        Block block = VaultCrateBlock.getCrateBlock(type);
        ItemStack crate = new ItemStack((ItemLike)block);
        CompoundTag nbt = new CompoundTag();
        NBTHelper.writeCollection(nbt, "items", items, CompoundTag.class, OverSizedItemStack::serialize);
        if (!nbt.m_128456_()) {
            crate.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        return crate;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.VAULT_CRATE_TILE_ENTITY.m_155264_(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_() && !world.f_46443_) {
            boolean poppedItems = false;
            boolean emptiedCrate = false;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof VaultCrateTileEntity) {
                VaultCrateTileEntity crate = (VaultCrateTileEntity)blockEntity;
                int remainingToDrop = 256;
                ListIterator<OverSizedItemStack> iterator = crate.getItems().listIterator();
                while (iterator.hasNext() && remainingToDrop > 0) {
                    int dropCount;
                    OverSizedItemStack oversizedStack = iterator.next();
                    if (oversizedStack.isEmpty()) {
                        iterator.remove();
                        continue;
                    }
                    int extractAmount = Math.min(oversizedStack.amount(), remainingToDrop);
                    if (extractAmount <= 0) continue;
                    ItemStack template = oversizedStack.stack().m_41777_();
                    for (int amountLeft = extractAmount; amountLeft > 0; amountLeft -= dropCount) {
                        dropCount = Math.min(amountLeft, template.m_41741_());
                        ItemStack dropStack = template.m_41777_();
                        dropStack.m_41764_(dropCount);
                        VaultCrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)dropStack);
                    }
                    remainingToDrop -= extractAmount;
                    poppedItems = true;
                    int leftoverAmount = oversizedStack.amount() - extractAmount;
                    if (leftoverAmount > 0) {
                        iterator.set(oversizedStack.copyAmount(leftoverAmount));
                        continue;
                    }
                    iterator.remove();
                }
                if (poppedItems) {
                    crate.sendUpdates();
                }
                emptiedCrate = crate.getItems().isEmpty();
            }
            if (poppedItems) {
                Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
                world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.CRATE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
                    serverLevel.m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 400, 1.0, 1.0, 1.0, 0.5);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175831_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 50, 1.0, 1.0, 1.0, 0.5);
                }
            }
            if (emptiedCrate) {
                world.m_7471_(pos, false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof VaultCrateTileEntity) {
            VaultCrateTileEntity crate = (VaultCrateTileEntity)tileentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            CompoundTag compoundnbt = crate.m_187482_();
            if (!compoundnbt.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
            }
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placeDir = context.m_7820_().m_122424_();
        Direction horizontalDir = Direction.NORTH;
        if (placeDir.m_122434_().m_122478_()) {
            for (Direction direction : context.m_6232_()) {
                if (!direction.m_122434_().m_122479_()) continue;
                horizontalDir = direction;
                break;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDir)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)horizontalDir);
    }

    private VaultCrateTileEntity getCrateTileEntity(Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof VaultCrateTileEntity)) {
            return null;
        }
        VaultCrateTileEntity tile = (VaultCrateTileEntity)blockEntity;
        return tile;
    }

    public static enum Type {
        BOSS,
        SCAVENGER,
        CAKE,
        ARENA,
        CHAMPION,
        BOUNTY,
        MONOLITH,
        ELIXIR,
        PARADOX,
        BINGO,
        RUNE_BOSS,
        GREED;

    }
}

