/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.mojang.math.Vector3f;
import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.base.InventoryRetainerBlock;
import iskallia.vault.block.entity.VoidCrucibleTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.world.data.VoidStoneBlacklistData;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class VoidCrucibleBlock
extends FacedBlock
implements EntityBlock,
InventoryRetainerBlock<VoidCrucibleTileEntity> {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)13.0, (double)3.0, (double)4.0, (double)15.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)4.0), Block.m_49796_((double)3.0, (double)13.0, (double)12.0, (double)13.0, (double)15.0, (double)14.0), Block.m_49796_((double)12.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public VoidCrucibleBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 3600000.0f).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof VoidCrucibleTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        final VoidCrucibleTileEntity voidCrucible = (VoidCrucibleTileEntity)te;
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        voidCrucible.transferCraftingItemsToPlayer(player);
        VoidStoneBlacklistData data = VoidStoneBlacklistData.get(sPlayer.m_183503_());
        VoidStoneBlacklistData.BlacklistInventory blacklistInventory = data.getInventory(sPlayer);
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return ModBlocks.VOID_CRUCIBLE.m_49954_();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return voidCrucible.m_7208_(windowId, inventory, player);
            }
        }, buffer -> {
            buffer.m_130064_(pos);
            buffer.m_130079_(blacklistInventory.serializeNBT());
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new VoidCrucibleTileEntity(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        this.addInventoryTooltip(stack, tooltip, VoidCrucibleTileEntity::addInventoryTooltip);
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        double x = (double)pos.m_123341_() + 0.5 + (rand.nextDouble() - 0.5) * 0.25;
        double y = (double)pos.m_123342_() + 0.85;
        double z = (double)pos.m_123343_() + 0.5 + (rand.nextDouble() - 0.5) * 0.25;
        DustParticleOptions options = new DustParticleOptions(new Vector3f(0.5f, 0.0f, 1.0f), 1.0f);
        world.m_7106_((ParticleOptions)options, x, y, z, 0.01, 0.15, 0.01);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onInventoryBlockDestroy(level, pos, state, newState);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.onInventoryBlockPlace(level, pos, stack);
    }
}

