/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeBlock;

public interface InventoryRetainerBlock<T extends BlockEntity>
extends IForgeBlock {
    default public void addInventoryTooltip(ItemStack stack, List<Component> tooltip, BiFunction<ItemStack, CompoundTag, InventoryRetainerTileEntity.ContentDisplayInfo> tooltipProviderFn) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("StoredInventory")) {
            return;
        }
        if (!Screen.m_96638_()) {
            tooltip.add((Component)new TextComponent("Hold Shift to view contents").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            return;
        }
        InventoryRetainerTileEntity.ContentDisplayInfo displayInfo = tooltipProviderFn.apply(stack, tag.m_128469_("StoredInventory"));
        if (displayInfo.display().isEmpty()) {
            return;
        }
        if (tooltip.size() > 1) {
            tooltip.add(TextComponent.f_131282_);
        }
        tooltip.add((Component)new TextComponent("Contains:").m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(displayInfo.display().subList(0, Math.min(displayInfo.display().size(), displayInfo.displayCount())));
        Component moreCmp = displayInfo.hasMoreCmp().apply(displayInfo.display().size() - displayInfo.displayCount());
        if (moreCmp != null) {
            tooltip.add(moreCmp);
        }
    }

    default public void onInventoryBlockDestroy(Level level, BlockPos pos, BlockState state, BlockState newState) {
        InventoryRetainerBlock inventoryRetainerBlock;
        if (state.m_155947_() && (!state.m_60713_(newState.m_60734_()) || !newState.m_155947_()) && (inventoryRetainerBlock = this) instanceof Block) {
            Block thisblock = (Block)inventoryRetainerBlock;
            inventoryRetainerBlock = level.m_7702_(pos);
            if (inventoryRetainerBlock instanceof InventoryRetainerTileEntity) {
                InventoryRetainerTileEntity tileEntity = (InventoryRetainerTileEntity)((Object)inventoryRetainerBlock);
                ItemStack drop = new ItemStack((ItemLike)thisblock);
                this.storeInventoryContents(drop.m_41784_(), (BlockEntity)tileEntity);
                tileEntity.clearInventoryContents();
                this.dropItem(level, pos, drop);
            }
        }
    }

    default public void onInventoryBlockPlace(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InventoryRetainerTileEntity) {
            InventoryRetainerTileEntity tileEntity = (InventoryRetainerTileEntity)blockEntity;
            if (stack.m_41782_()) {
                CompoundTag tag = stack.m_41784_();
                this.loadInventoryContents(tag, (BlockEntity)tileEntity);
            }
        }
    }

    default public void storeInventoryContents(CompoundTag tag, T tile) {
        CompoundTag storedInventory = new CompoundTag();
        ((InventoryRetainerTileEntity)tile).storeInventoryContents(storedInventory);
        tag.m_128365_("StoredInventory", (Tag)storedInventory);
    }

    default public void loadInventoryContents(CompoundTag tag, T tile) {
        CompoundTag storedInventory = tag.m_128469_("StoredInventory");
        if (storedInventory.m_128456_()) {
            return;
        }
        ((InventoryRetainerTileEntity)tile).loadInventoryContents(storedInventory);
    }

    default public ItemEntity dropItem(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
        return entity;
    }
}

