/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.discoverable;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DiscoverTriggeringBlock
extends Block {
    public static BooleanProperty DISCOVERED = BooleanProperty.m_61465_((String)"discovered");
    protected List<Pair<DiscoveryStrategy, ResourceLocation>> discoveries;
    protected VoxelShape shape;
    public static final DiscoveryStrategy GEAR_MODEL_DISCOVERY = (player, discoverId) -> {
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.m_183503_());
        ModDynamicModels.REGISTRIES.getModelAndAssociatedItem(discoverId).ifPresent(pair -> {
            Item item = (Item)pair.getSecond();
            modelsData.discoverModelAndBroadcast(item, discoverId, (Player)player);
        });
    };
    public static final DiscoveryStrategy ARMOR_MODEL_DISCOVERY = (player, modelId) -> {
        DiscoveredModelsData modelsData = DiscoveredModelsData.get(player.m_183503_());
        ModDynamicModels.Armor.MODEL_REGISTRY.get(modelId).map(ArmorModel::getPieces).ifPresent(pieces -> pieces.forEach((equipmentSlot, armorPieceModel) -> modelsData.discoverModelAndBroadcast((Item)VaultArmorItem.forSlot(equipmentSlot), armorPieceModel.getId(), (Player)player)));
    };

    public DiscoverTriggeringBlock(List<Pair<DiscoveryStrategy, ResourceLocation>> discoveries, BlockBehaviour.Properties properties) {
        this(discoveries, properties, null);
    }

    public DiscoverTriggeringBlock(List<Pair<DiscoveryStrategy, ResourceLocation>> discoveries, BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.discoveries = discoveries;
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISCOVERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return this.shape == null ? super.m_5940_(state, pLevel, pPos, pContext) : this.shape;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISCOVERED});
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.m_61124_((Property)DISCOVERED, (Comparable)Boolean.valueOf(true));
    }

    public void m_5707_(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!world.f_46443_ && !player.m_7500_()) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
            if (!((Boolean)state.m_61143_((Property)DISCOVERED)).booleanValue()) {
                for (Pair<DiscoveryStrategy, ResourceLocation> discovery : this.discoveries) {
                    DiscoveryStrategy strategy = (DiscoveryStrategy)discovery.getFirst();
                    ResourceLocation discoverId = (ResourceLocation)discovery.getSecond();
                    strategy.discover((ServerPlayer)player, discoverId);
                }
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    @FunctionalInterface
    static interface DiscoveryStrategy {
        public void discover(ServerPlayer var1, ResourceLocation var2);
    }
}

