/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.container.AlchemyTableContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.network.message.ClientboundAlchemyParticleMessage;
import iskallia.vault.network.message.ClientboundAlchemySecondParticleMessage;
import iskallia.vault.network.message.ClientboundTESyncMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class AlchemyTableTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity {
    private boolean crafting = false;
    private int craftingOutputCooldown = -1;
    public static int CRAFTING_COOLDOWN = 60;
    private float extraSpinDegrees = 0.0f;
    private float extraSpinDegreesPrev = 0.0f;
    private final SimpleContainer inventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            AlchemyTableTileEntity.this.m_6596_();
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof BottleItem;
        }
    };
    private ItemStack fakeItemStack = ItemStack.f_41583_;

    public AlchemyTableTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ALCHEMY_TABLE_TILE_ENTITY, pos, state);
    }

    public float getExtraSpinDegrees() {
        return this.extraSpinDegrees;
    }

    public float getExtraSpinDegreesPrev() {
        return this.extraSpinDegreesPrev;
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public ItemStack getFakeItemStack() {
        return this.fakeItemStack;
    }

    public int getCraftingOutputCooldown() {
        return this.craftingOutputCooldown;
    }

    public boolean stillValid(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && !this.crafting;
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getFilteredInputCapability(side, new Container[]{this.inventory});
        }
        return super.getCapability(cap, side);
    }

    public void startCrafting() {
        this.crafting = true;
        this.craftingOutputCooldown = CRAFTING_COOLDOWN;
        this.fakeItemStack = this.getInventory().m_8020_(0).m_41777_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, this.m_187482_()));
        }
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NBTHelper.deserializeSimpleContainer(this.inventory, tag.m_128437_("inventory", 10));
        if (tag.m_128441_("fakeItem")) {
            this.fakeItemStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("fakeItem"));
        }
        this.crafting = tag.m_128471_("crafting");
        this.craftingOutputCooldown = tag.m_128451_("craftingOutputCooldown");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
        tag.m_128365_("fakeItem", (Tag)this.fakeItemStack.m_41739_(new CompoundTag()));
        tag.m_128379_("crafting", this.crafting);
        tag.m_128405_("craftingOutputCooldown", this.craftingOutputCooldown);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new AlchemyTableContainer(id, this.m_58904_(), this.m_58899_(), inventory);
    }

    public void dropItemStack(Level pLevel, double pX, double pY, double pZ, ItemStack pStack) {
        Random random = new Random();
        while (!pStack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(pLevel, pX, pY, pZ, pStack.m_41620_(random.nextInt(21) + 10));
            itementity.m_20334_(0.0, random.nextGaussian() * (double)0.05f + (double)0.2f, 0.0);
            itementity.m_32010_(10);
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public static float ease(double x) {
        if (x == 0.0) {
            return 0.0f;
        }
        if (x == 1.0) {
            return 1.0f;
        }
        if (x < 0.5) {
            return (float)Math.pow(2.0, 20.0 * x - 10.0) / 2.0f;
        }
        return (float)(2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0f;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                if (!this.crafting) {
                    return;
                }
                if (this.craftingOutputCooldown > 0) {
                    if (this.craftingOutputCooldown == CRAFTING_COOLDOWN) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12590_, SoundSource.BLOCKS, 0.35f, 1.5f);
                    }
                    if (this.craftingOutputCooldown == CRAFTING_COOLDOWN - 5) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12537_, SoundSource.BLOCKS, 0.35f, 1.5f);
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144243_, SoundSource.BLOCKS, 2.0f, 1.0f);
                    }
                    if (this.craftingOutputCooldown == 35) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 0.5f, 1.5f);
                    }
                    if (this.craftingOutputCooldown == 20) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144049_, SoundSource.BLOCKS, 0.5f, 1.5f);
                    }
                    if (this.craftingOutputCooldown == 19) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144049_, SoundSource.BLOCKS, 0.45f, 2.0f);
                    }
                    int color = BottleItem.getEffectColor(this.getInventory().m_8020_(0));
                    if (this.craftingOutputCooldown > 40 && this.craftingOutputCooldown < CRAFTING_COOLDOWN - 2) {
                        float f = 1.0f - (float)(this.craftingOutputCooldown - 40) / (float)(CRAFTING_COOLDOWN - 40);
                        f = AlchemyTableTileEntity.ease(f);
                        float yOffset = (float)Math.sin((double)f * Math.PI / 1.5) / 8.0f;
                        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundAlchemyParticleMessage(this.m_58899_(), dir, color, yOffset));
                    }
                    if (this.craftingOutputCooldown == 20) {
                        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundAlchemySecondParticleMessage(this.m_58899_(), color));
                    }
                    --this.craftingOutputCooldown;
                    return;
                }
                this.crafting = false;
                this.dropItemStack(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, this.inventory.m_8020_(0));
                this.inventory.m_6836_(0, ItemStack.f_41583_);
                ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, this.m_187482_()));
            } else {
                if (!this.crafting) {
                    this.extraSpinDegrees = 0.0f;
                    this.extraSpinDegreesPrev = 0.0f;
                    return;
                }
                if (this.craftingOutputCooldown > 0) {
                    this.extraSpinDegreesPrev = this.extraSpinDegrees;
                    if (this.craftingOutputCooldown < CRAFTING_COOLDOWN) {
                        float f = 1.0f - (float)this.craftingOutputCooldown / (float)CRAFTING_COOLDOWN;
                        f = AlchemyTableTileEntity.ease(f);
                        this.extraSpinDegrees = f * -720.0f;
                    }
                    --this.craftingOutputCooldown;
                }
            }
        }
    }
}

