/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class AnimatrixTileEntity
extends BlockEntity {
    private Entity entityToRender;
    private boolean displayOnly;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public AnimatrixTileEntity(BlockPos pPos, BlockState pState) {
        super(ModBlocks.ANIMATRIX_TILE_ENTITY, pPos, pState);
    }

    public boolean isDisplayOnly() {
        return this.displayOnly;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (AnimatrixTileEntity.this.f_58857_ != null && !((AnimatrixTileEntity)AnimatrixTileEntity.this).f_58857_.f_46443_) {
                    AnimatrixTileEntity.this.setEntityToRender(AnimatrixTileEntity.this.itemHandler.getStackInSlot(0));
                    AnimatrixTileEntity.this.m_6596_();
                }
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (AnimatrixTileEntity.this.itemHandler.getStackInSlot(0).m_41619_()) {
                    return true;
                }
                return stack.m_41656_(AnimatrixTileEntity.this.itemHandler.getStackInSlot(0)) && AnimatrixTileEntity.this.itemHandler.getStackInSlot(0).m_41613_() + stack.m_41613_() <= 1;
            }
        };
    }

    public void m_142466_(CompoundTag pTag) {
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.displayOnly = pTag.m_128471_("displayOnly");
        this.setEntityToRender(this.itemHandler.getStackInSlot(0));
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128379_("displayOnly", this.displayOnly);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public Entity getEntityToRender() {
        return this.entityToRender;
    }

    public void setEntityToRender(ItemStack item) {
        if (this.f_58857_ == null) {
            return;
        }
        if (item.m_41720_() instanceof SpawnEggItem) {
            this.entityToRender = ((SpawnEggItem)item.m_41720_()).m_43228_(null).m_20615_(this.f_58857_);
        } else if (item.m_41619_()) {
            this.entityToRender = null;
        }
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

