/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.serializable.INbtSerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.rune.RuneBossFight;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.BlockCuboid;
import iskallia.vault.core.world.storage.WorldZone;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.ScavengerAltarConsumeMessage;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldZonesData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class BossRunePillarTileEntity
extends BlockEntity {
    protected static final BlockPos[] PARTICLE_POSITIONS = new BlockPos[]{BlockPos.f_121853_.m_142126_(), BlockPos.f_121853_.m_142125_(), BlockPos.f_121853_.m_142128_(), BlockPos.f_121853_.m_142127_(), BlockPos.f_121853_.m_142127_().m_142127_(), BlockPos.f_121853_.m_142127_().m_142126_(), BlockPos.f_121853_.m_142127_().m_142125_(), BlockPos.f_121853_.m_142128_().m_142128_(), BlockPos.f_121853_.m_142128_().m_142126_(), BlockPos.f_121853_.m_142128_().m_142125_(), BlockPos.f_121853_.m_142125_().m_142125_(), BlockPos.f_121853_.m_142126_().m_142126_()};
    public static final int MAX_CONSUME_TICKS = 20;
    private final Config config = new Config();
    private boolean populated;
    private int zoneId;
    private int runeCount;
    private int runeMinimum;
    private PartialEntity boss;
    private final BossRuneModifiers modifiers = new BossRuneModifiers();
    private final List<ItemStack> loot = new ArrayList<ItemStack>();
    private ItemStack heldItem = ItemStack.f_41583_;
    private UUID itemPlacedBy;
    public int ticksToConsume = 20;
    public int ticksToConsumeOld;
    public boolean consuming = false;

    public BossRunePillarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.BOSS_RUNE_PILLAR_TILE_ENTITY, pos, state);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public int getRuneCount() {
        return this.runeCount;
    }

    public void setRuneCount(int runeCount) {
        this.runeCount = runeCount;
        this.refreshAbilityModifiers();
    }

    public int getRuneMinimum() {
        return this.runeMinimum;
    }

    public PartialEntity getBoss() {
        return this.boss;
    }

    public BossRuneModifiers getModifiers() {
        return this.modifiers;
    }

    public List<ItemStack> getLoot() {
        return this.loot;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public UUID getItemPlacedBy() {
        return this.itemPlacedBy;
    }

    public void setItemPlacedBy(UUID itemPlacedBy) {
        this.itemPlacedBy = itemPlacedBy;
    }

    public RuneBossFight createFight() {
        return new RuneBossFight(this.m_58899_(), this.config.zone, this.zoneId, this.config.roomStyle, this.boss, this.modifiers.copy(), this.loot);
    }

    public void onPopulate() {
        ChunkRandom random = ChunkRandom.any();
        random.setDecoratorSeed(ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.SEED)).orElse(0L), this.m_58899_().m_123341_(), this.m_58899_().m_123343_(), 329045113);
        if (this.config.count == null) {
            this.config.count = IntRoll.ofConstant(3);
        }
        this.runeMinimum = this.config.count.get(random);
        this.boss = this.config.boss.getRandom(random).orElseGet(() -> PartialEntity.parse("minecraft:pig", true).orElseThrow());
        this.populated = true;
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (!this.isPopulated()) {
                this.onPopulate();
            }
            if (this.zoneId <= 0 && this.config.zone != null) {
                this.zoneId = WorldZonesData.get(world.m_142572_()).getOrCreate((ResourceKey<Level>)world.m_46472_()).add(new WorldZone().add(this.config.zone.offset((Vec3i)this.m_58899_())).setModify(false));
            }
            this.refreshAbilityModifiers();
        }
    }

    private void refreshAbilityModifiers() {
        BossRuneModifiers modifiers = this.getModifiers();
        if (ModConfigs.RUNE_BOSS != null) {
            modifiers.setShieldAbility(ModConfigs.RUNE_BOSS.getShieldSettings(this.runeCount).orElse(null));
            modifiers.setWaveBlastAbility(ModConfigs.RUNE_BOSS.getWaveBlastSettings(this.runeCount).orElse(null));
            modifiers.setReviveAbility(ModConfigs.RUNE_BOSS.getReviveSettings(this.runeCount).orElse(null));
        } else {
            modifiers.setShieldAbility(null);
            modifiers.setWaveBlastAbility(null);
            modifiers.setReviveAbility(null);
        }
    }

    public static void tickClient(Level world, BlockPos pos, BlockState state, BossRunePillarTileEntity tile) {
        tile.playEffects(world);
        if (tile.getHeldItem().m_41619_()) {
            return;
        }
        tile.ticksToConsumeOld = tile.ticksToConsume;
        if (tile.ticksToConsume > 0) {
            --tile.ticksToConsume;
        }
    }

    public static void tickServer(Level world, BlockPos pos, BlockState state, BossRunePillarTileEntity tile) {
        if (!tile.isPopulated()) {
            tile.onPopulate();
        }
        if (tile.heldItem.m_41619_()) {
            return;
        }
        if (tile.ticksToConsume > 0) {
            if (!tile.consuming) {
                tile.consuming = true;
                world.m_5594_(null, pos, SoundEvents.f_11736_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            --tile.ticksToConsume;
        } else {
            tile.ticksToConsume = 20;
            tile.consuming = false;
            ItemStack original = tile.heldItem.m_41777_();
            if (tile.config.rune == null) {
                VaultMod.LOGGER.error("Vault Rune Pillar Tile Entity: Vault Rune or held item is null");
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)tile.heldItem);
                tile.setHeldItem(ItemStack.f_41583_);
                tile.setItemPlacedBy(null);
                return;
            }
            if (tile.config.rune.test(tile.heldItem)) {
                CommonEvents.SCAVENGER_ALTAR_CONSUME.invoke(world, tile);
            }
            if (tile.heldItem.m_41613_() != original.m_41613_()) {
                world.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5594_(null, pos, SoundEvents.f_12321_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ScavengerAltarConsumeMessage(tile.m_58899_()));
            } else {
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
            Block.m_49840_((Level)world, (BlockPos)pos.m_7494_(), (ItemStack)tile.heldItem);
            tile.setHeldItem(ItemStack.f_41583_);
            tile.setItemPlacedBy(null);
        }
        tile.sendUpdates();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playEffects(Level world) {
        JavaRandom random = JavaRandom.ofNanoTime();
        BlockPos above = this.m_58899_().m_7494_();
        Vec3 center = new Vec3((double)above.m_123341_() + 0.5, (double)above.m_123342_() + 0.5, (double)above.m_123343_() + 0.5);
        int particleSpeed = this.consuming && (float)this.ticksToConsume > 16.0f ? 5 : 40;
        for (BlockPos pos : PARTICLE_POSITIONS) {
            for (int offset = 0; offset < 3; ++offset) {
                if (random.nextInt(particleSpeed) != 0) continue;
                world.m_7106_((ParticleOptions)ModParticles.BOSS_RUNE_CORE.get(), center.f_82479_, center.f_82480_, center.f_82481_, (double)(-0.5f + random.nextFloat() + (float)pos.m_123341_()), (double)(-2.0f + random.nextFloat() + (float)pos.m_123342_() + (float)offset), (double)(-0.5f + random.nextFloat() + (float)pos.m_123343_()));
            }
        }
        if (random.nextInt(10) == 0) {
            Vec3 pos = new Vec3((double)((float)above.m_123341_() + 0.5f + (random.nextFloat() - random.nextFloat()) * (random.nextFloat() * 3.0f) / 10.0f), (double)((float)above.m_123342_() - 0.25f + (random.nextFloat() - random.nextFloat()) * (random.nextFloat() * 3.0f) / 10.0f), (double)((float)above.m_123343_() + 0.5f + (random.nextFloat() - random.nextFloat()) * (random.nextFloat() * 3.0f) / 10.0f));
            world.m_7106_((ParticleOptions)ModParticles.BOSS_RUNE_CORE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.config.writeNbt().ifPresent(tag -> nbt.m_128365_("config", (Tag)tag));
        Adapters.BOOLEAN.writeNbt(this.populated).ifPresent(tag -> nbt.m_128365_("populated", tag));
        Adapters.INT.writeNbt(this.zoneId).ifPresent(tag -> nbt.m_128365_("zoneId", tag));
        Adapters.INT.writeNbt(this.runeCount).ifPresent(tag -> nbt.m_128365_("runeCount", tag));
        Adapters.INT.writeNbt(this.runeMinimum).ifPresent(tag -> nbt.m_128365_("runeTarget", tag));
        Adapters.PARTIAL_ENTITY.writeNbt(this.boss).ifPresent(tag -> nbt.m_128365_("boss", tag));
        nbt.m_128365_("modifiers", (Tag)this.modifiers.toNbt());
        ListTag loot = new ListTag();
        this.loot.forEach(stack -> Adapters.ITEM_STACK.writeNbt((ItemStack)stack).ifPresent(arg_0 -> loot.add(arg_0)));
        nbt.m_128365_("loot", (Tag)loot);
        Adapters.ITEM_STACK.writeNbt(this.heldItem).ifPresent(tag -> nbt.m_128365_("heldItem", tag));
        Adapters.UUID.writeNbt(this.itemPlacedBy).ifPresent(tag -> nbt.m_128365_("itemPlacedBy", tag));
        Adapters.INT.writeNbt(this.ticksToConsume).ifPresent(tag -> nbt.m_128365_("ticksToConsume", tag));
        Adapters.INT.writeNbt(this.ticksToConsumeOld).ifPresent(tag -> nbt.m_128365_("ticksToConsumeOld", tag));
        Adapters.BOOLEAN.writeNbt(this.consuming).ifPresent(tag -> nbt.m_128365_("consuming", tag));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (!nbt.m_128441_("config")) {
            this.config.readNbt(nbt);
            return;
        }
        this.populated = Adapters.BOOLEAN.readNbt(nbt.m_128423_("populated")).orElse(false);
        this.zoneId = Adapters.INT.readNbt(nbt.m_128423_("zoneId")).orElse(-1);
        this.runeCount = Adapters.INT.readNbt(nbt.m_128423_("runeCount")).orElse(0);
        this.runeMinimum = Adapters.INT.readNbt(nbt.m_128423_("runeTarget")).orElse(3);
        this.boss = Adapters.PARTIAL_ENTITY.readNbt(nbt.m_128423_("boss")).orElse(null);
        this.config.readNbt(nbt.m_128469_("config"));
        this.modifiers.readFrom(nbt.m_128469_("modifiers"));
        this.refreshAbilityModifiers();
        ListTag loot = nbt.m_128437_("loot", 10);
        this.loot.clear();
        for (int i = 0; i < loot.size(); ++i) {
            Adapters.ITEM_STACK.readNbt((Tag)loot.m_128728_(i)).ifPresent(this.loot::add);
        }
        this.heldItem = Adapters.ITEM_STACK.readNbt(nbt.m_128423_("heldItem")).orElse(ItemStack.f_41583_);
        this.itemPlacedBy = Adapters.UUID.readNbt(nbt.m_128423_("itemPlacedBy")).orElse(null);
        this.ticksToConsume = Adapters.INT.readNbt(nbt.m_128423_("ticksToConsume")).orElse(20);
        this.ticksToConsumeOld = Adapters.INT.readNbt(nbt.m_128423_("ticksToConsumeOld")).orElse(0);
        this.consuming = Adapters.BOOLEAN.readNbt(nbt.m_128423_("consuming")).orElse(false);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnConsumeParticles(BlockPos pos) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 40; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ModParticles.BOSS_RUNE_CORE_CONSUME.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 30; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)ModParticles.BOSS_RUNE_CORE_CONSUME.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2 + 0.2, offset.f_82481_ / 20.0);
        }
    }

    public static class Config
    implements INbtSerializable<CompoundTag> {
        private ItemPredicate rune;
        private IntRoll count;
        private final WeightedList<PartialEntity> boss = new WeightedList();
        private BlockCuboid zone;
        private RuneBossFight.RoomStyle roomStyle;

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.ITEM_PREDICATE.writeNbt(this.rune).ifPresent(tag -> nbt.m_128365_("rune", tag));
                Adapters.INT_ROLL.writeNbt(this.count).ifPresent(tag -> nbt.m_128365_("count", tag));
                ListTag boss = new ListTag();
                this.boss.forEach((entity, weight) -> Adapters.PARTIAL_ENTITY.writeNbt((PartialEntity)entity).ifPresent(tag -> {
                    if (tag instanceof CompoundTag) {
                        CompoundTag compound = (CompoundTag)tag;
                        Adapters.DOUBLE.writeNbt(weight).ifPresent(tag1 -> compound.m_128365_("weight", tag1));
                        boss.add(tag);
                    }
                }));
                nbt.m_128365_("boss", (Tag)boss);
                Adapters.BLOCK_CUBOID.writeNbt(this.zone).ifPresent(tag -> nbt.m_128365_("zone", tag));
                Adapters.ofEnum(RuneBossFight.RoomStyle.class, EnumAdapter.Mode.NAME).writeNbt(this.roomStyle).ifPresent(tag -> nbt.m_128365_("roomStyle", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.rune = Adapters.ITEM_PREDICATE.readNbt(nbt.m_128423_("rune")).orElse(ItemPredicate.of("the_vault:boss_rune", false).orElse(ItemPredicate.FALSE));
            this.count = Adapters.INT_ROLL.readNbt(nbt.m_128423_("count")).orElse(IntRoll.ofConstant(3));
            ListTag boss = nbt.m_128437_("boss", 10);
            this.boss.clear();
            for (int i = 0; i < boss.size(); ++i) {
                double weight = Adapters.DOUBLE.readNbt(boss.m_128728_(i).m_128423_("weight")).orElse(1.0);
                Adapters.PARTIAL_ENTITY.readNbt((Tag)boss.m_128728_(i)).ifPresent(entity -> this.boss.put((PartialEntity)entity, weight));
            }
            this.zone = Adapters.BLOCK_CUBOID.readNbt(nbt.m_128423_("zone")).orElse(null);
            this.roomStyle = Adapters.ofEnum(RuneBossFight.RoomStyle.class, EnumAdapter.Mode.NAME).readNbt(nbt.m_128423_("roomStyle")).orElse(RuneBossFight.RoomStyle.BOSS_1);
        }
    }
}

