/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.block.entity.base.InventoryRetainerTileEntity;
import iskallia.vault.container.BountyContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.world.data.BountyData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public class BountyTableTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity,
InventoryRetainerTileEntity {
    private final OverSizedInventory inventory = new OverSizedInventory.FilteredInsert(1, this, (slot, stack) -> stack.m_150930_((Item)ModItems.BOUNTY_PEARL));

    public BountyTableTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.BOUNTY_TABLE_TILE_ENTITY, pos, state);
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inventory.m_6542_(player);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.load(tag);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.inventory.save(tag);
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getFilteredInputCapability(side, new Container[]{this.inventory});
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inv, @NotNull Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BountyData data = BountyData.get();
        int vaultLevel = PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel();
        CompoundTag tag = data.getAllBountiesAsTagFor(sPlayer.m_142081_());
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_58899_()));
        tag.m_128405_("vaultLevel", vaultLevel);
        return new BountyContainer(containerId, this.m_58904_(), inv, tag);
    }

    public static InventoryRetainerTileEntity.ContentDisplayInfo addInventoryTooltip(ItemStack stack, CompoundTag tag) {
        return InventoryRetainerTileEntity.displayContentsOverSized(5, lists -> lists.addAll(OverSizedInventory.loadContents("inventory", tag)));
    }

    @Override
    public void storeInventoryContents(CompoundTag tag) {
        this.inventory.save("inventory", tag);
    }

    @Override
    public void loadInventoryContents(CompoundTag tag) {
        this.inventory.load("inventory", tag);
    }

    @Override
    public void clearInventoryContents() {
        this.inventory.m_6211_();
    }
}

