/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.UniqueCrateGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BreakableCrateTileEntity
extends ChestBlockEntity {
    private boolean generated;
    private int generatedStacksCount;
    private int size;
    private boolean vaultCrate;

    public BreakableCrateTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.UNIQUE_CRATE_TILE_ENTITY, pos, state);
    }

    public void m_59640_(Player player) {
        this.generateChestLoot(player, false);
    }

    public void m_5856_(Player pPlayer) {
        super.m_5856_(pPlayer);
    }

    public void generateChestLoot(Player source, boolean compress) {
        ServerPlayer player;
        block8: {
            block7: {
                if (this.m_58904_() == null || this.m_58904_().m_5776_() || !(source instanceof ServerPlayer)) break block7;
                player = (ServerPlayer)source;
                if (!this.generated && this.vaultCrate) break block8;
            }
            return;
        }
        if (MiscUtils.isPlayerFakeMP(player) || source.m_5833_()) {
            this.generated = true;
            this.generatedStacksCount = 0;
            this.m_6596_();
            return;
        }
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        UniqueCrateGenerationEvent.Data data = CommonEvents.UNIQUE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, Version.latest(), JavaRandom.ofNanoTime(), UniqueCrateGenerationEvent.Phase.PRE);
        this.f_59605_ = data.getLootTable();
        if (this.f_59605_ == null) {
            this.generated = true;
            this.generatedStacksCount = 0;
            this.m_6596_();
            return;
        }
        this.generateLootTable(data.getVersion(), source, loot, data.getRandom());
        CommonEvents.UNIQUE_CRATE_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.f_59605_, this, loot, data.getVersion(), data.getRandom(), UniqueCrateGenerationEvent.Phase.POST);
        PlayerVaultStatsData stats = PlayerVaultStatsData.get(player.m_183503_());
        PlayerVaultStats statsData = stats.getVaultStats((Player)player);
        int level = statsData.getVaultLevel();
        if (ServerVaults.get((Level)player.m_183503_()).isPresent()) {
            level = ServerVaults.get((Level)player.m_183503_()).get().get(Vault.LEVEL).get();
        }
        this.fillLoot(loot, compress, data.getRandom(), level);
        this.generated = true;
        this.generatedStacksCount = 0;
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.generatedStacksCount += this.m_8020_(i).m_41619_() ? 1 : 0;
        }
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    private void generateLootTable(Version version, @Nullable Player player, List<ItemStack> loot, RandomSource random) {
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(this.f_59605_);
        if (key != null) {
            LootTableGenerator generator = new LootTableGenerator(version, key, 0.0f);
            generator.setSource((Entity)player);
            generator.generate(random);
            generator.getItems().forEachRemaining(loot::add);
        }
        this.m_6596_();
    }

    public void fillLoot(List<ItemStack> loot, boolean compress, RandomSource random, int vaultLevel) {
        if (compress) {
            List<ItemStack> mergedLoot = MiscUtils.splitAndLimitStackSize(MiscUtils.mergeItemStacks(loot));
            mergedLoot.forEach(stack -> MiscUtils.addItemStack((Container)this, LootInitialization.initializeVaultLoot(stack, vaultLevel)));
            this.m_6596_();
            return;
        }
        if (loot.size() > this.size) {
            loot = MiscUtils.splitAndLimitStackSize(MiscUtils.mergeItemStacks(loot));
        }
        List<Integer> slots = this.getAvailableSlots((Container)this, random);
        for (ItemStack itemstack : loot) {
            if (slots.isEmpty()) break;
            itemstack = LootInitialization.initializeVaultLoot(itemstack, vaultLevel);
            this.m_6836_(slots.remove(slots.size() - 1), itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack);
        }
        this.m_6596_();
    }

    private List<Integer> getAvailableSlots(Container pInventory, RandomSource pRand) {
        int i;
        ArrayList list = Lists.newArrayList();
        for (i = 0; i < pInventory.m_6643_(); ++i) {
            if (!pInventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        for (i = list.size(); i > 1; --i) {
            int index = pRand.nextInt(i);
            int temp = (Integer)list.get(i - 1);
            list.set(i - 1, (Integer)list.get(index));
            list.set(index, temp);
        }
        return list;
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        super.m_6836_(index, stack);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = super.m_7407_(index, count);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = super.m_8016_(index);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return stack;
    }

    protected boolean m_59631_(CompoundTag nbt) {
        super.m_59631_(nbt);
        return false;
    }

    protected boolean m_59634_(CompoundTag nbt) {
        super.m_59634_(nbt);
        return false;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.generated = nbt.m_128471_("Generated");
        this.generatedStacksCount = nbt.m_128451_("GeneratedStacksCount");
        this.vaultCrate = nbt.m_128425_("LootTable", 8) && !nbt.m_128461_("LootTable").isBlank();
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Generated", this.generated);
        nbt.m_128405_("GeneratedStacksCount", this.generatedStacksCount);
    }

    public boolean isVaultCrate() {
        return this.vaultCrate;
    }

    public void setVaultCrate(boolean vaultCrate) {
        this.vaultCrate = vaultCrate;
        this.m_6596_();
    }

    public boolean m_7525_(Player pPlayer) {
        if (this.isVaultCrate() && !pPlayer.m_7500_()) {
            return false;
        }
        return super.m_7525_(pPlayer);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

