/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.CardEssenceExtractorConfig;
import iskallia.vault.core.card.Card;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.item.CardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardEssenceExtractorTileEntity
extends BlockEntity {
    private int essence = 0;
    private final ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CardEssenceExtractorTileEntity.this.sendUpdates();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.m_41619_()) {
                return true;
            }
            if (slot == 0) {
                return stack.m_150930_((Item)ModItems.CARD) || stack.m_150930_((Item)ModItems.CARD_DECK);
            }
            if (slot == 1) {
                return stack.m_41720_() instanceof CardItem;
            }
            return slot != 2 && super.isItemValid(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> inputCapability = LazyOptional.empty();
    private int maxExtractWorkTick = -1;
    private int extractWorkTick = -1;

    public CardEssenceExtractorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.CARD_ESSENCE_EXTRACTOR_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CardEssenceExtractorTileEntity tile) {
        if (level.m_5776_()) {
            return;
        }
        if (tile.extractWorkTick < 0) {
            return;
        }
        if (tile.inventory.getStackInSlot(0).m_41619_()) {
            tile.resetExtractTick();
            tile.sendUpdates();
            return;
        }
        --tile.extractWorkTick;
        if (tile.extractWorkTick <= 0) {
            tile.resetExtractTick();
            tile.extractCardEssence();
        }
        tile.sendUpdates();
    }

    public void resetExtractTick() {
        this.extractWorkTick = -1;
        this.maxExtractWorkTick = -1;
    }

    private void extractCardEssence() {
        ItemStack essenceInputStack = this.inventory.getStackInSlot(0);
        if (essenceInputStack.m_41619_()) {
            return;
        }
        ItemStack processedStack = essenceInputStack.m_41777_();
        processedStack.m_41764_(1);
        if (processedStack.m_150930_((Item)ModItems.CARD)) {
            Card card = CardItem.getCard(processedStack);
            int tier = card.getTier();
            ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(tier).ifPresent(cfg -> this.essence += cfg.getEssencePerCard().getRandom());
        }
        if (processedStack.m_150930_((Item)ModItems.CARD_DECK)) {
            String id = CardDeckItem.getId(processedStack);
            ModConfigs.CARD_DECK.getEssence(id).ifPresent(essence -> this.essence += essence.intValue());
        }
        this.inventory.extractItem(0, 1, false);
        Level level = this.m_58904_();
        if (level != null) {
            level.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_11772_, SoundSource.PLAYERS, 0.8f, level.f_46441_.nextFloat() * 0.3f + 1.7f);
        }
    }

    public void startExtract() {
        ItemStack essenceInputStack = this.inventory.getStackInSlot(0);
        if (essenceInputStack.m_41619_()) {
            return;
        }
        if (!essenceInputStack.m_150930_((Item)ModItems.CARD) && !essenceInputStack.m_150930_((Item)ModItems.CARD_DECK)) {
            return;
        }
        if (this.extractWorkTick >= 0) {
            return;
        }
        int extractTime = -1;
        if (essenceInputStack.m_150930_((Item)ModItems.CARD)) {
            Card card = CardItem.getCard(essenceInputStack);
            int tier = card.getTier();
            extractTime = ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(tier).map(CardEssenceExtractorConfig.TierConfig::getExtractTickTime).orElse(-1);
        } else if (essenceInputStack.m_150930_((Item)ModItems.CARD_DECK)) {
            extractTime = ModConfigs.CARD_ESSENCE_EXTRACTOR.getConfig(1).map(CardEssenceExtractorConfig.TierConfig::getExtractTickTime).orElse(-1);
        }
        if (extractTime > 0) {
            this.extractWorkTick = extractTime;
            this.maxExtractWorkTick = extractTime;
            this.sendUpdates();
        }
    }

    public IItemHandlerModifiable getInventoryHandler() {
        return this.inventory;
    }

    public float getExtractProgress() {
        if (this.extractWorkTick < 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)(1.0f - (float)this.extractWorkTick / (float)this.maxExtractWorkTick), (float)0.0f, (float)1.0f);
    }

    public int getEssence() {
        return this.essence;
    }

    public void setEssence(int essence) {
        this.essence = essence;
        this.sendUpdates();
    }

    public ItemStack getEssenceInputStack() {
        return this.inventory.getStackInSlot(0).m_41777_();
    }

    public void setEssenceInputStack(ItemStack essenceInputStack) {
        this.inventory.setStackInSlot(0, essenceInputStack.m_41777_());
    }

    public ItemStack getCardUpgradeStack() {
        return this.inventory.getStackInSlot(1).m_41777_();
    }

    public void setCardUpgradeStack(ItemStack cardUpgradeStack) {
        this.inventory.setStackInSlot(1, cardUpgradeStack.m_41777_());
    }

    public ItemStack getCardUpgradeOutputStack() {
        return this.inventory.getStackInSlot(2).m_41777_();
    }

    public void setCardUpgradeOutputStack(ItemStack cardOutputStack) {
        this.inventory.setStackInSlot(2, cardOutputStack.m_41777_());
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.essence = tag.m_128451_("essence");
        this.extractWorkTick = tag.m_128451_("extractWorkTick");
        this.maxExtractWorkTick = tag.m_128451_("maxExtractWorkTick");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("essence", this.essence);
        tag.m_128405_("extractWorkTick", this.extractWorkTick);
        tag.m_128405_("maxExtractWorkTick", this.maxExtractWorkTick);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.inputCapability.isPresent()) {
                this.inputCapability = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
            }
            return this.inputCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.inputCapability.invalidate();
        this.inputCapability = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputCapability.invalidate();
        this.inputCapability = LazyOptional.empty();
    }
}

