/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.HunterHiddenTileEntity;
import iskallia.vault.block.entity.base.TemplateTagContainer;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.CoinStacksGenerationEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.world.VaultLoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CoinPilesTileEntity
extends BlockEntity
implements HunterHiddenTileEntity,
TemplateTagContainer {
    private ResourceLocation lootTable;
    private boolean hidden;
    private final List<String> templateTags = new ArrayList<String>();

    public CoinPilesTileEntity(BlockPos p_155630_, BlockState p_155631_) {
        super(ModBlocks.COIN_PILE_TILE, p_155630_, p_155631_);
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        if (this.hidden != this.hidden) {
            this.m_6596_();
        }
    }

    public List<ItemStack> generateLoot(ServerPlayer player) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        CoinStacksGenerationEvent.Data data = CommonEvents.COIN_STACK_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, Version.latest(), JavaRandom.ofNanoTime(), CoinStacksGenerationEvent.Phase.PRE);
        LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(data.getLootTable());
        if (key != null) {
            LootTableGenerator generator = new LootTableGenerator(Version.latest(), key, 0.0f);
            generator.setSource((Entity)player);
            generator.generate(data.getRandom());
            ArrayList generatedItems = new ArrayList();
            generator.getItems().forEachRemaining(generatedItems::add);
            float multiplier = ((VaultLoot.GameRuleValue)player.m_183503_().m_46469_().m_46170_(ModGameRules.LOOT)).get().getMultiplier();
            for (ItemStack stack : generatedItems) {
                int newCount = Math.max(1, Math.round((float)stack.m_41613_() * multiplier));
                stack.m_41764_(newCount);
                loot.add(stack);
            }
        }
        CommonEvents.COIN_STACK_LOOT_GENERATION.invoke(player, this.m_58900_(), this.m_58899_(), this.lootTable, this, loot, data.getVersion(), data.getRandom(), CoinStacksGenerationEvent.Phase.POST);
        return loot;
    }

    @Override
    public List<String> getTemplateTags() {
        return Collections.unmodifiableList(this.templateTags);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("LootTable", 8)) {
            this.lootTable = new ResourceLocation(nbt.m_128461_("LootTable"));
        }
        this.hidden = nbt.m_128471_("Hidden");
        this.templateTags.clear();
        this.templateTags.addAll(this.loadTemplateTags(nbt));
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.lootTable != null) {
            nbt.m_128359_("LootTable", this.lootTable.toString());
        }
        nbt.m_128379_("Hidden", this.hidden);
        this.saveTemplateTags(nbt);
    }
}

