/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import iskallia.vault.block.CompanionHomeBlock;
import iskallia.vault.entity.entity.PetEntity;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionSeries;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CompanionHomeTileEntity
extends BlockEntity {
    private static final String COMPANION_TAG = "companion";
    private static final String COLOUR_TAG = "Colour";
    private ItemStack companion = ItemStack.f_41583_;
    private int colour = 0xFFFFFF;
    @Nullable
    private PetEntity renderPet;
    private static final int COOLDOWN_CACHE_TICKS = 200;
    private int cachedCooldownPercent = 0;
    private long nextCooldownUpdate = 0L;
    private static final Cache<UUID, Integer> CACHE_TOTAL_COOLDOWN = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private static final Cache<UUID, Integer> CACHE_CURRENT_COOLDOWN = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public CompanionHomeTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.COMPANION_HOME_TILE_ENTITY, pos, state);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.updateRenderPet();
        }
    }

    public ItemStack getCompanion() {
        return this.companion;
    }

    public void setCompanion(ItemStack stack) {
        this.companion = stack;
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.updateRenderPet();
        } else if (this.f_58857_ != null) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        UUID uuid = CompanionItem.getCompanionUUID(stack);
        if (uuid != null) {
            CACHE_CURRENT_COOLDOWN.invalidate((Object)uuid);
            CACHE_TOTAL_COOLDOWN.invalidate((Object)uuid);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.companion = ItemStack.m_41712_((CompoundTag)tag.m_128469_(COMPANION_TAG));
        if (tag.m_128441_(COLOUR_TAG)) {
            this.colour = tag.m_128451_(COLOUR_TAG);
        }
        this.updateRenderPet();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(COMPANION_TAG, (Tag)this.companion.serializeNBT());
        tag.m_128405_(COLOUR_TAG, this.colour);
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        this.colour = colour;
        if (this.f_58857_ != null) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public PetEntity getRenderPet() {
        if (this.renderPet == null && this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.updateRenderPet();
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.renderPet.getFactory().getOrCreateAnimationData((int)this.renderPet.m_142049_()).tick += 1.0;
        }
        return this.renderPet;
    }

    private void updateRenderPet() {
        this.renderPet = null;
        Level level = this.m_58904_();
        if (level == null || this.companion.m_41619_() || !(this.companion.m_41720_() instanceof CompanionItem)) {
            return;
        }
        CompanionSeries series = CompanionItem.getPetSeries(this.companion);
        EntityType<PetEntity> entityType = this.getEntityTypeForCompanion(series, CompanionItem.getPetType(this.companion));
        PetEntity pet = new PetEntity(entityType, level);
        pet.setCompanionData(this.companion);
        if (series == CompanionSeries.LEGEND) {
            String playerName = CompanionItem.getPetName(this.companion);
            if (playerName != null && !playerName.isEmpty()) {
                pet.setGameProfile(new GameProfile(null, playerName));
            }
        } else if (!pet.m_5803_()) {
            pet.setSleeping(true);
        }
        this.renderPet = pet;
    }

    private EntityType<PetEntity> getEntityTypeForCompanion(CompanionSeries series, String petType) {
        if (series == CompanionSeries.LEGEND) {
            return ModEntities.PET;
        }
        if (series == CompanionSeries.PET) {
            return PetHelper.getVariant(petType).map(PetHelper.PetVariant::entityType).orElse(ModEntities.PET);
        }
        return ModEntities.PET;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompanionHomeTileEntity tile) {
        if (level.m_5776_()) {
            return;
        }
        long time = level.m_46467_();
        int percent = tile.cachedCooldownPercent;
        if (time >= tile.nextCooldownUpdate) {
            tile.nextCooldownUpdate = time + 200L;
            percent = tile.cachedCooldownPercent = tile.calculateCooldownPercent();
        }
        if ((Integer)state.m_61143_((Property)CompanionHomeBlock.COOLDOWN_PERCENT) != percent) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CompanionHomeBlock.COOLDOWN_PERCENT, (Comparable)Integer.valueOf(percent)), 3);
        }
    }

    private int calculateCooldownPercent() {
        int percent = 10;
        ItemStack stack = this.getCompanion();
        if (!stack.m_41619_() && stack.m_41720_() instanceof CompanionItem) {
            if (!CompanionItem.isOnCooldown(stack)) {
                return 0;
            }
            int current = this.getCurrentCooldown(stack);
            int totalSeconds = this.getTotalCooldownSeconds(stack);
            percent = totalSeconds > 0 ? Mth.m_14045_((int)Math.round((float)current / (float)totalSeconds * 10.0f), (int)1, (int)10) : 0;
        }
        return percent;
    }

    private int getCurrentCooldown(ItemStack stack) {
        UUID compId = CompanionItem.getCompanionUUID(stack);
        if (compId == null) {
            return 0;
        }
        Integer current = (Integer)CACHE_CURRENT_COOLDOWN.getIfPresent((Object)compId);
        if (current != null) {
            return current;
        }
        int currentSeconds = CompanionItem.getCurrentCooldown(stack);
        CACHE_CURRENT_COOLDOWN.put((Object)compId, (Object)currentSeconds);
        return currentSeconds;
    }

    private int getTotalCooldownSeconds(ItemStack stack) {
        UUID compId = CompanionItem.getCompanionUUID(stack);
        if (compId == null) {
            return 0;
        }
        Integer total = (Integer)CACHE_TOTAL_COOLDOWN.getIfPresent((Object)compId);
        if (total != null) {
            return total;
        }
        int base = CompanionItem.getBaseCooldown(stack);
        float multiplier = ModConfigs.COMPANIONS.getCooldownMultiplier();
        int totalMinutes = base + Math.round((float)base * multiplier * (float)(CompanionItem.getCompanionLevel(stack) - 1));
        int totalSeconds = totalMinutes * 60;
        CACHE_TOTAL_COOLDOWN.put((Object)compId, (Object)totalSeconds);
        return totalSeconds;
    }
}

