/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.container.CompanionIncubatorContainer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CompanionEggItem;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.util.nbt.NBTHelper;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CompanionIncubatorTileEntity
extends BlockEntity
implements MenuProvider,
IAnimatable {
    private static final String OWNER_TAG = "owner";
    public static final IntegerProperty CRACK = IntegerProperty.m_61631_((String)"crack", (int)0, (int)3);
    private static final String INVENTORY_TAG = "inventory";
    private static final String TIME_TAG = "time";
    private final SimpleContainer inventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            CompanionIncubatorTileEntity.this.m_6596_();
        }
    };
    private GameProfile owner;
    public int timeLeft;
    public final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    protected static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("idle.incubator", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected static final AnimationBuilder SHAKE = new AnimationBuilder().addAnimation("shake.incubator", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public CompanionIncubatorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.COMPANION_INCUBATOR_TILE_ENTITY, pos, state);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void startHatching(GameProfile profile, int time) {
        this.owner = profile;
        this.timeLeft = time;
        this.updateCrackStage();
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompanionIncubatorTileEntity tile) {
        if (level.m_5776_()) {
            return;
        }
        if (tile.inventory.m_7983_()) {
            return;
        }
        ItemStack stack = tile.inventory.m_8020_(0);
        if (stack.m_41720_() instanceof CompanionEggItem) {
            if (tile.timeLeft <= 0) {
                ItemStack companion = new ItemStack((ItemLike)ModItems.COMPANION);
                CompanionItem.generateCompanionDataForSeries(companion, JavaRandom.ofNanoTime(), CompanionEggItem.getSeries(stack));
                if (tile.owner != null) {
                    CompanionItem.setOwner(companion, tile.owner.getId());
                    CompanionItem.setOwnerName(companion, tile.owner.getName());
                }
                CompanionItem.setCompanionLevel(companion, 1);
                CompanionItem.setCompanionXP(companion, 0);
                CompanionItem.setCompanionHearts(companion, 1);
                CompanionItem.setCompanionMaxHearts(companion, 1);
                int cooldownMinutes = ModConfigs.COMPANIONS.getRandomCooldown(JavaRandom.ofNanoTime());
                companion.m_41784_().m_128405_("baseCooldown", cooldownMinutes);
                CompanionItem.setTemporalModifier(companion, CompanionItem.getRandomTemporalModifier().getId());
                CompanionItem.setVaultRuns(companion, 0);
                String hatchedDate = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toLocalDate().toString();
                CompanionItem.setHatchedDate(companion, hatchedDate);
                companion.m_41784_().m_128405_("relicSlots", 0);
                companion.m_41784_().m_128405_("cosmeticSlots", 0);
                CompanionItem.setActive(companion, false);
                tile.inventory.m_6836_(0, companion);
                tile.timeLeft = 0;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CRACK, (Comparable)Integer.valueOf(3)), 3);
                level.m_7260_(pos, state, state, 3);
                tile.updateCrackStage();
                tile.m_6596_();
            } else if (level.m_46467_() % 20L == 0L) {
                --tile.timeLeft;
                CompanionEggItem.setRemainingTime(stack, tile.timeLeft);
                tile.updateCrackStage();
                tile.m_6596_();
            }
        }
    }

    public Component m_5446_() {
        return new TextComponent("Companion Incubator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new CompanionIncubatorContainer(windowId, this.f_58857_, this.f_58858_, inventory);
    }

    private int getCrackStage() {
        int total = ModConfigs.COMPANIONS.getHatchingTime();
        int stage = (int)(3.0f - 3.0f * (float)this.timeLeft / (float)total);
        return Math.max(0, Math.min(3, stage));
    }

    private void updateCrackStage() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        int stage = this.getCrackStage();
        if ((Integer)state.m_61143_((Property)CRACK) != stage) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)CRACK, (Comparable)Integer.valueOf(stage)), 3);
        } else {
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(OWNER_TAG, 10)) {
            this.owner = NbtUtils.m_129228_((CompoundTag)tag.m_128469_(OWNER_TAG));
        }
        this.timeLeft = tag.m_128451_(TIME_TAG);
        NBTHelper.deserializeSimpleContainer(this.inventory, tag.m_128437_(INVENTORY_TAG, 10));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            tag.m_128365_(OWNER_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.owner));
        }
        tag.m_128405_(TIME_TAG, this.timeLeft);
        tag.m_128365_(INVENTORY_TAG, (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 0.0f, this::idleAnimation));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Action", 0.0f, this::actionAnimation));
    }

    protected <E extends CompanionIncubatorTileEntity> PlayState idleAnimation(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle.incubator", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    protected <E extends CompanionIncubatorTileEntity> PlayState actionAnimation(AnimationEvent<E> event) {
        if (!this.hasEgg()) {
            event.getController().setAnimation(SHAKE);
            event.getController().markNeedsReload();
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean hasEgg() {
        return !this.inventory.m_8020_(0).m_41619_() && this.inventory.m_8020_(0).m_41720_() instanceof CompanionEggItem;
    }

    public boolean hasCompanion() {
        return !this.inventory.m_8020_(0).m_41619_() && this.inventory.m_8020_(0).m_41720_() instanceof CompanionItem;
    }
}

