/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.container.RenamingContainer;
import iskallia.vault.container.inventory.CryochamberContainer;
import iskallia.vault.entity.entity.EternalSpiritEntity;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.RenameType;
import iskallia.vault.util.SkinProfile;
import iskallia.vault.world.data.EternalsData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class CryoChamberTileEntity
extends BlockEntity
implements MenuProvider {
    protected SkinProfile skin;
    private UUID owner;
    public List<String> coreNames = new ArrayList<String>();
    private int maxCores = 0;
    private boolean infusing = false;
    private int infusionTimeRemaining = 0;
    private boolean growingEternal = false;
    private int growEternalTimeRemaining = 0;
    protected UUID eternalId;
    protected UUID eternalIdPrev;
    public float lastCoreCount;
    public int eternalSoulsConsumed = 0;
    public EternalsData.EternalVariant variant;
    public boolean usingPlayerSkin = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            if (this.getStackInSlot(slot).m_41720_() == ModItems.ETERNAL_SOUL) {
                CryoChamberTileEntity.this.addEternalSoul();
                this.setStackInSlot(slot, ItemStack.f_41583_);
            }
            CryoChamberTileEntity.this.sendUpdates();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ModItems.ETERNAL_SOUL && !CryoChamberTileEntity.this.isFull() && !CryoChamberTileEntity.this.isInfusing();
        }
    };
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    protected CryoChamberTileEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.skin = new SkinProfile();
    }

    public void resetAll() {
        this.skin = new SkinProfile();
        this.eternalSoulsConsumed = 0;
        this.coreNames = new ArrayList<String>();
        this.maxCores = 0;
        this.infusing = false;
        this.infusionTimeRemaining = 0;
        this.growingEternal = false;
        this.growEternalTimeRemaining = 0;
        this.eternalId = null;
        this.lastCoreCount = 0.0f;
        this.usingPlayerSkin = false;
    }

    public CryoChamberTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.CRYO_CHAMBER_TILE_ENTITY, pos, state);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public int getMaxCores() {
        return this.maxCores;
    }

    public void setMaxCores(int maxCores) {
        this.maxCores = maxCores;
    }

    public boolean isInfusing() {
        return this.infusing;
    }

    public int getInfusionTimeRemaining() {
        return this.infusionTimeRemaining;
    }

    public boolean isGrowingEternal() {
        return this.growingEternal;
    }

    public int getGrowEternalTimeRemaining() {
        return this.growEternalTimeRemaining;
    }

    public SkinProfile getSkin() {
        return this.skin;
    }

    public int getCoreCount() {
        return this.eternalSoulsConsumed;
    }

    public boolean addEternalSoul() {
        int newCores;
        if (this.isFull() || this.isInfusing() || this.getOwner() == null) {
            return false;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sWorld = (ServerLevel)level;
        sWorld.m_6263_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Optional knownProfile = sWorld.m_142572_().m_129927_().m_11002_(this.getOwner());
        if (knownProfile.isEmpty()) {
            return false;
        }
        int eternals = EternalsData.get(sWorld).getEternals(this.getOwner()).getNonAncientEternalCount();
        int cores = this.getMaxCores();
        if (cores != (newCores = ModConfigs.CRYO_CHAMBER.getPlayerCoreCount(((GameProfile)knownProfile.get()).getName(), eternals))) {
            this.setMaxCores(newCores);
            this.sendUpdates();
        }
        ++this.eternalSoulsConsumed;
        this.infusing = true;
        this.infusionTimeRemaining = ModConfigs.CRYO_CHAMBER.getInfusionTime();
        this.sendUpdates();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSkin() {
        EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(this.getEternalId());
        if (snapshot == null || snapshot.getName() == null) {
            return;
        }
        this.skin.updateSkin(snapshot.getName());
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    @Nullable
    public EternalData getEternal() {
        if (this.m_58904_() == null) {
            return null;
        }
        if (!this.m_58904_().m_5776_()) {
            if (this.eternalId == null) {
                return null;
            }
            return EternalsData.get((ServerLevel)this.m_58904_()).getEternals(this.owner).get(this.eternalId);
        }
        return null;
    }

    public UUID getEternalId() {
        return this.eternalId;
    }

    protected boolean isFull() {
        return this.eternalSoulsConsumed != 0 && this.eternalSoulsConsumed >= this.maxCores;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CryoChamberTileEntity tile) {
        if (level == null || level.f_46443_ || tile.owner == null) {
            return;
        }
        if (tile.isFull() && !tile.growingEternal && tile.eternalId == null) {
            tile.growingEternal = true;
            tile.growEternalTimeRemaining = ModConfigs.CRYO_CHAMBER.getGrowEternalTime();
        }
        if (tile.isFull() && !tile.growingEternal && level.m_46467_() % 40L == 0L) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11768_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
        if (tile.infusing) {
            if (tile.infusionTimeRemaining-- <= 0) {
                tile.infusionTimeRemaining = 0;
                tile.infusing = false;
            }
            tile.sendUpdates();
        } else if (tile.growingEternal) {
            if (tile.growEternalTimeRemaining-- <= 0) {
                tile.growEternalTimeRemaining = 0;
                tile.growingEternal = false;
                tile.createEternal();
            }
            tile.sendUpdates();
        }
    }

    public void pickupSpirit(Player player, CryoChamberTileEntity cryoChamberTileEntity) {
        Entity entity = ModEntities.ETERNAL_SPIRIT.m_20592_((ServerLevel)player.f_19853_, null, null, player.m_142538_(), MobSpawnType.EVENT, false, false);
        if (entity instanceof EternalSpiritEntity) {
            EternalSpiritEntity spirit = (EternalSpiritEntity)entity;
            EternalsData.get((ServerLevel)player.f_19853_).getEternal(cryoChamberTileEntity.eternalId);
            GameProfile profile = cryoChamberTileEntity.getSkin().gameProfile.get();
            if (profile != null) {
                spirit.setGameProfile(profile);
            }
            spirit.setEternalUUID(cryoChamberTileEntity.eternalId);
            spirit.setOwnerUUID(player.m_142081_());
            spirit.putInPlayersHand(player);
        }
    }

    public void renameEternal(ServerPlayer player) {
        final CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("RenameType", RenameType.CRYO_CHAMBER.ordinal());
        nbt.m_128365_("Data", (Tag)this.getRenameNBT());
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Rename Eternal");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                return new RenamingContainer(windowId, nbt);
            }
        }, buffer -> buffer.m_130079_(nbt));
    }

    private void createEternal() {
        EternalsData.EternalVariant variant;
        String name;
        EternalsData.EternalGroup eternals = EternalsData.get((ServerLevel)this.m_58904_()).getEternals(this.owner);
        int attempts = 50;
        do {
            name = ModConfigs.ETERNALS_NAMEPOOL.getRandomName();
        } while (--attempts > 0 && eternals.containsEternal(name));
        this.variant = variant = EternalsData.EternalVariant.byId(new Random().nextInt(EternalsData.EternalVariant.values().length));
        this.eternalId = EternalsData.get((ServerLevel)this.m_58904_()).add(this.owner, name, false, variant, false);
    }

    public Component m_5446_() {
        EternalData eternal = this.getEternal();
        if (eternal != null) {
            return new TextComponent(eternal.getName());
        }
        return new TextComponent("Cryo Chamber");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new CryochamberContainer(windowId, this.m_58904_(), this.m_58899_(), playerInventory);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        }
        if (this.eternalId != null) {
            nbt.m_128362_("EternalId", this.eternalId);
        }
        nbt.m_128405_("MaxCoreCount", this.maxCores);
        nbt.m_128379_("Infusing", this.infusing);
        nbt.m_128405_("InfusionTimeRemaining", this.infusionTimeRemaining);
        nbt.m_128379_("GrowingEternal", this.growingEternal);
        nbt.m_128405_("GrowEternalTimeRemaining", this.growEternalTimeRemaining);
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("EternalSoulsConsumed", this.eternalSoulsConsumed);
        nbt.m_128379_("UsingPlayerSkin", this.usingPlayerSkin);
        if (this.variant != null) {
            nbt.m_128405_("EternalVariant", this.variant.getId());
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Owner")) {
            this.owner = nbt.m_128342_("Owner");
        }
        if (nbt.m_128441_("EternalId")) {
            this.eternalId = nbt.m_128342_("EternalId");
        }
        this.maxCores = nbt.m_128451_("MaxCoreCount");
        this.infusing = nbt.m_128471_("Infusing");
        this.infusionTimeRemaining = nbt.m_128451_("InfusionTimeRemaining");
        this.growingEternal = nbt.m_128471_("GrowingEternal");
        this.growEternalTimeRemaining = nbt.m_128451_("GrowEternalTimeRemaining");
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
        this.eternalSoulsConsumed = nbt.m_128451_("EternalSoulsConsumed");
        this.usingPlayerSkin = nbt.m_128471_("UsingPlayerSkin");
        if (nbt.m_128441_("EternalVariant")) {
            this.variant = EternalsData.EternalVariant.byId(nbt.m_128451_("EternalVariant"));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.handler.cast() : super.getCapability(cap, side);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag getRenameNBT() {
        CompoundTag nbt = new CompoundTag();
        EternalData eternal = this.getEternal();
        if (eternal == null) {
            return nbt;
        }
        nbt.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_58899_()));
        nbt.m_128359_("EternalName", eternal.getName());
        return nbt;
    }

    public void renameEternal(String name) {
        if (this.getEternal() != null) {
            this.getEternal().setName(name);
        }
    }
}

