/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.base.FilteredInputInventoryTileEntity;
import iskallia.vault.container.CrystalWorkbenchContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.AugmentItem;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.VaultCrystalItem;
import iskallia.vault.item.crystal.properties.CapacityCrystalProperties;
import iskallia.vault.item.crystal.properties.CrystalProperties;
import iskallia.vault.item.crystal.recipe.AnvilExecutor;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.item.gear.CharmItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class CrystalWorkbenchTileEntity
extends BlockEntity
implements MenuProvider,
FilteredInputInventoryTileEntity {
    private final OverSizedInventory input = new OverSizedInventory.FilteredInsert(1, this, (slot, stack) -> stack.m_41720_() instanceof VaultCrystalItem && !CrystalData.read(stack).getProperties().isUnmodifiable()){

        @Override
        public void m_6596_() {
            super.m_6596_();
            CrystalWorkbenchTileEntity.this.updateExecutors();
        }

        @Override
        public int m_6893_() {
            return 1;
        }
    };
    private final OverSizedInventory ingredients = new OverSizedInventory.FilteredInsert(60, this, (slot, stack) -> stack.m_41720_() instanceof InfusedCatalystItem || stack.m_41720_() instanceof InscriptionItem || stack.m_41720_() instanceof CharmItem){

        @Override
        public void m_6596_() {
            super.m_6596_();
            CrystalWorkbenchTileEntity.this.updateExecutors();
        }

        @Override
        public int m_6893_() {
            return 1;
        }
    };
    private final OverSizedInventory uniqueIngredients = new OverSizedInventory.FilteredInsert(3, this, (slot, stack) -> {
        if (slot == 0) {
            return stack.m_204117_(ModItems.CRYSTAL_SEALS_TAG);
        }
        if (slot == 1) {
            return stack.m_41720_() instanceof AugmentItem;
        }
        return stack.m_204117_(ModItems.CRYSTAL_CAPSTONES_TAG);
    }){

        @Override
        public void m_6596_() {
            super.m_6596_();
            CrystalWorkbenchTileEntity.this.updateExecutors();
        }

        @Override
        public int m_6893_() {
            return 1;
        }
    };
    private Set<Player> players = new HashSet<Player>();
    private Map<UUID, AnvilExecutor.Result> executors = new HashMap<UUID, AnvilExecutor.Result>();
    private int firstCursedIngredient = 1000;

    public CrystalWorkbenchTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.CRYSTAL_WORKBENCH_ENTITY, pos, state);
    }

    @Override
    public boolean isInventorySideAccessible(@Nullable Direction side) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getFilteredInputCapability(side, new Container[]{this.input, this.ingredients, this.uniqueIngredients});
        }
        return super.getCapability(cap, side);
    }

    public OverSizedInventory getInput() {
        return this.input;
    }

    public OverSizedInventory getIngredients() {
        return this.ingredients;
    }

    public OverSizedInventory getUniqueIngredients() {
        return this.uniqueIngredients;
    }

    public AnvilExecutor.Result getExecutor(UUID uuid) {
        return this.executors.get(uuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AnvilExecutor.Result getClientExecutor() {
        return this.executors.get(Minecraft.m_91087_().m_91403_().m_105144_().getId());
    }

    public int getFirstCursedIngredient() {
        return this.firstCursedIngredient;
    }

    private void updateExecutor(Player player) {
        this.executors.put(player.m_36316_().getId(), AnvilExecutor.test(player, this.input.m_8020_(0), this.ingredients.getContents(), this.uniqueIngredients.getContents()));
        this.calculateFirstCursedIngredient();
    }

    private void calculateFirstCursedIngredient() {
        CrystalData data;
        CrystalProperties crystalProperties;
        this.firstCursedIngredient = 1000;
        ItemStack crystal = this.input.m_8020_(0);
        if (crystal.m_41720_() instanceof VaultCrystalItem && (crystalProperties = (data = CrystalData.read(crystal)).getProperties()) instanceof CapacityCrystalProperties) {
            CapacityCrystalProperties capacityCrystalProperties = (CapacityCrystalProperties)crystalProperties;
            capacityCrystalProperties.getCapacity().ifPresent(capacity -> {
                for (int i = 0; i < this.ingredients.m_6643_(); ++i) {
                    ItemStack ingredient = this.ingredients.m_8020_(i);
                    if (ingredient.m_41720_() instanceof InfusedCatalystItem) {
                        capacity = capacity - InfusedCatalystItem.getSize(ingredient).orElse(0);
                    } else if (ingredient.m_41720_() instanceof InscriptionItem) {
                        capacity = capacity - InscriptionData.from(ingredient).getSize();
                    } else if (ingredient.m_41720_() instanceof CharmItem) {
                        capacity = capacity - CharmItem.getCrystalIngredientSize();
                    }
                    if (capacity >= 0) continue;
                    this.firstCursedIngredient = i;
                    break;
                }
            });
        }
    }

    private void updateExecutors() {
        for (Player player : this.players) {
            this.executors.put(player.m_36316_().getId(), AnvilExecutor.test(player, this.input.m_8020_(0), this.ingredients.getContents(), this.uniqueIngredients.getContents()));
        }
        this.calculateFirstCursedIngredient();
    }

    public void onCraft(Player player) {
        int i;
        this.updateExecutor(player);
        AnvilExecutor.Result executor = this.executors.get(player.m_36316_().getId());
        if (executor == null) {
            return;
        }
        for (i = 0; i < executor.getIngredients().length; ++i) {
            this.ingredients.m_6836_(i, executor.getIngredients()[i]);
        }
        for (i = 0; i < executor.getUniqueIngredients().length; ++i) {
            this.uniqueIngredients.m_6836_(i, executor.getUniqueIngredients()[i]);
        }
        this.input.m_6836_(0, executor.getOutput());
        block2: for (ItemStack extra : executor.getExtra()) {
            int left = extra.m_41613_();
            for (int i2 = 0; i2 < this.ingredients.m_6643_(); ++i2) {
                ItemStack stack = this.ingredients.m_8020_(i2);
                if (left <= 0) continue block2;
                if (!stack.m_41619_() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)extra)) continue;
                int difference = Math.min(extra.m_41741_() - stack.m_41613_(), left);
                ItemStack copy = extra.m_41777_();
                copy.m_41764_(stack.m_41613_() + difference);
                this.ingredients.m_6836_(i2, copy);
                left -= difference;
            }
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), ModSounds.ARTISAN_SMITHING, SoundSource.BLOCKS, 0.2f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.input.m_6542_(player) && this.ingredients.m_6542_(player);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new CrystalWorkbenchContainer(containerId, this.m_58904_(), this.m_58899_(), player);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.input.save("input", nbt);
        this.ingredients.save("ingredients", nbt);
        this.uniqueIngredients.save("uniqueIngredients", nbt);
        CompoundTag executors = new CompoundTag();
        this.executors.forEach((uuid, result) -> result.writeNbt().ifPresent(executor -> executors.m_128365_(uuid.toString(), (Tag)executor)));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.input.load("input", nbt);
        this.ingredients.load("ingredients", nbt);
        this.uniqueIngredients.load("uniqueIngredients", nbt);
        this.executors.clear();
        CompoundTag executors = nbt.m_128469_("executors");
        for (String key : executors.m_128431_()) {
            AnvilExecutor.Result executor = new AnvilExecutor.Result();
            executor.readNbt(executors.m_128469_(key));
            this.executors.put(UUID.fromString(key), executor);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onOpen(Player player) {
        this.players.add(player);
        this.updateExecutor(player);
    }

    public void onClose(Player player) {
        this.players.add(player);
        this.executors.remove(player.m_36316_().getId());
    }
}

