/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.DehammerizerBlock;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class DehammerizerTileEntity
extends BlockEntity {
    private static final int RANGE = 32;

    public DehammerizerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.DEHAMMERIZER_TILE_ENTITY, pos, state);
    }

    public static boolean hasDemhammerizerAround(Entity entity) {
        return DehammerizerTileEntity.getDemagnetizers(entity, 32.0).stream().filter(demagnetizer -> demagnetizer.m_58904_() == entity.f_19853_).filter(demagnetizer -> demagnetizer.m_58900_().m_61145_((Property)DehammerizerBlock.DEACTIVATED).isPresent()).anyMatch(demagnetizer -> (Boolean)demagnetizer.m_58900_().m_61143_((Property)DehammerizerBlock.DEACTIVATED) == false);
    }

    private static List<DehammerizerTileEntity> getDemagnetizers(Entity entity, double radius) {
        ArrayList<DehammerizerTileEntity> demagnetizers = new ArrayList<DehammerizerTileEntity>();
        BlockPos entityPosition = entity.m_142538_();
        double radiusSq = radius * radius;
        int iRadius = Mth.m_14165_((double)radius);
        Vec3i radVec = new Vec3i(iRadius, iRadius, iRadius);
        ChunkPos posMin = new ChunkPos(entityPosition.m_141950_(radVec));
        ChunkPos posMax = new ChunkPos(entityPosition.m_141952_(radVec));
        for (int xx = posMin.f_45578_; xx <= posMax.f_45578_; ++xx) {
            for (int zz = posMin.f_45579_; zz <= posMax.f_45579_; ++zz) {
                LevelChunk ch = entity.m_183503_().m_7726_().m_7131_(xx, zz);
                if (ch == null) continue;
                Map blockEntities = ch.m_62954_();
                blockEntities.forEach((pos, tile) -> {
                    if (!(tile instanceof DehammerizerTileEntity)) {
                        return;
                    }
                    DehammerizerTileEntity demagnetizer = (DehammerizerTileEntity)((Object)tile);
                    if (pos.m_123331_((Vec3i)entityPosition) <= radiusSq) {
                        demagnetizers.add(demagnetizer);
                    }
                });
            }
        }
        return demagnetizers;
    }
}

