/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.BaseSpawnerTileEntity;
import iskallia.vault.config.EliteSpawnerConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EliteSpawnerTileEntity
extends BaseSpawnerTileEntity {
    private String spawnGroupName;

    public EliteSpawnerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ELITE_SPAWNER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, EliteSpawnerTileEntity te) {
        ServerLevel serverLevel;
        block6: {
            block5: {
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (level.m_45924_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (double)ModConfigs.ELITE_SPAWNER.blockCheckRadius, true) != null) break block6;
            }
            return;
        }
        EliteSpawnerConfig.SpawnerGroup spawnGroup = ModConfigs.ELITE_SPAWNER.spawnerGroups.get(te.spawnGroupName);
        if (spawnGroup == null) {
            VaultMod.LOGGER.warn("Elite Spawner failed to get spawn group \"{}\" as it does not exist in config", (Object)te.spawnGroupName);
            return;
        }
        int numberOfMinions = serverLevel.f_46441_.nextInt(spawnGroup.min, spawnGroup.max + 1);
        for (int i = 0; i < numberOfMinions; ++i) {
            EliteSpawnerConfig.SpawnerEntity randomMinion = spawnGroup.minions.getRandom(serverLevel.f_46441_);
            if (randomMinion == null) continue;
            ResourceLocation entityName = randomMinion.entityName;
            EliteSpawnerTileEntity.spawnEntity(blockPos, serverLevel, entityName, randomMinion.entityNbt, true, () -> EliteSpawnerTileEntity.logEntityTypeMissing(te.spawnGroupName, entityName));
        }
        EliteSpawnerTileEntity.spawnEntity(blockPos, serverLevel, spawnGroup.elite.entityName, spawnGroup.elite.entityNbt, true, () -> EliteSpawnerTileEntity.logEntityTypeMissing(te.spawnGroupName, spawnGroup.elite.entityName));
        level.m_7471_(blockPos, false);
    }

    private static void logEntityTypeMissing(String spawnGroupName, ResourceLocation entityName) {
        VaultMod.LOGGER.warn("Elite Spawner failed to spawn \"{}\" defined in spawn group \"{}\" as it does not exist in entityType registry", (Object)entityName, (Object)spawnGroupName);
    }

    public void setSpawnGroupName(String spawnGroupName) {
        this.spawnGroupName = spawnGroupName;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("spawnGroupName", this.spawnGroupName);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnGroupName = tag.m_128461_("spawnGroupName");
    }

    public void setRandomSpawn() {
        String[] spawnerGroupNames = ModConfigs.ELITE_SPAWNER.spawnerGroups.keySet().toArray(new String[0]);
        String spawnerGroupName = spawnerGroupNames[this.f_58857_.f_46441_.nextInt(spawnerGroupNames.length)];
        this.setSpawnGroupName(spawnerGroupName);
    }
}

