/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.block.EternalPedestalBlock;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.container.RenamingContainer;
import iskallia.vault.container.inventory.CryochamberContainer;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.entity.entity.EternalSpiritEntity;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.RenameType;
import iskallia.vault.util.SkinProfile;
import iskallia.vault.world.data.EternalsData;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EternalPedestalTileEntity
extends BlockEntity
implements IPlayerSkinHolder,
MenuProvider {
    private static final String GAME_PROFILE_TAG = "gameProfile";
    private static final String OWNER_TAG = "ownerUUID";
    private static final String ETERNAL_TAG = "eternalUUID";
    @Nullable
    private GameProfile gameProfile;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    private UUID owner;
    protected UUID eternalId;
    private SkinProfile skinProfile = new SkinProfile();
    private boolean updateSkin = false;

    public EternalPedestalTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ETERNAL_PEDESTAL_TILE_ENTITY, pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
        this.skinLocation = null;
        this.slimSkin = false;
        this.m_6596_();
    }

    public UUID getEternalId() {
        return this.eternalId;
    }

    public CompoundTag getRenameNBT() {
        CompoundTag nbt = new CompoundTag();
        EternalData eternal = this.getEternal();
        if (eternal == null) {
            return nbt;
        }
        nbt.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_58899_()));
        nbt.m_128359_("EternalName", eternal.getName());
        return nbt;
    }

    public void renameEternal(String name) {
        if (this.getEternal() != null) {
            this.getEternal().setName(name);
        }
    }

    public void renameEternal(ServerPlayer player) {
        final CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("RenameType", RenameType.CRYO_CHAMBER.ordinal());
        nbt.m_128365_("Data", (Tag)this.getRenameNBT());
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Rename Eternal");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                return new RenamingContainer(windowId, nbt);
            }
        }, buffer -> buffer.m_130079_(nbt));
    }

    public boolean interact(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        ItemStack stack = player.m_21120_(hand);
        Vec3 loc = hit.m_82450_();
        float[] offsets = new float[]{0.5f, 0.85f, 1.46f, 2.0f};
        float arms = 0.25f;
        float armsY = 1.75f;
        Vec3 base = new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f));
        float yPos = (float)(loc.f_82480_ - base.f_82480_);
        float xPos = (float)(loc.f_82479_ - base.f_82479_);
        float zPos = (float)(loc.f_82481_ - base.f_82481_);
        EternalDataSnapshot eternalSnapshot = null;
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EternalsData eternalsdata = EternalsData.get(serverLevel);
            EternalData eternalData = eternalsdata.getEternal(this.getEternalId());
            if (eternalData != null) {
                eternalSnapshot = EternalDataSnapshot.getFromEternal(eternalsdata.getEternals(this.getOwner()), eternalData);
            }
        } else {
            eternalSnapshot = ClientEternalData.getSnapshot(this.getEternalId());
        }
        if (yPos > 0.4375f && eternalSnapshot != null) {
            ItemStack temp;
            ArmorItem armor;
            Item soundEvent;
            ItemStack temp2;
            if (yPos > 0.5f && yPos < armsY && state.m_61138_((Property)EternalPedestalBlock.FACING)) {
                EternalData data;
                if (state.m_61143_((Property)EternalPedestalBlock.FACING) == Direction.WEST) {
                    if (zPos > arms) {
                        if (!stack.m_41619_() || !eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41619_()) {
                            temp2 = eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41777_();
                            if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                                data.setStack(EquipmentSlot.OFFHAND, stack.m_41777_());
                            }
                            player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                            EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                            return true;
                        }
                    } else if (!(!(zPos < -arms) || stack.m_41619_() && eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41619_())) {
                        temp2 = eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41777_();
                        if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                            data.setStack(EquipmentSlot.MAINHAND, stack.m_41777_());
                        }
                        player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                        EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                        return true;
                    }
                }
                if (state.m_61143_((Property)EternalPedestalBlock.FACING) == Direction.EAST) {
                    if (zPos > arms) {
                        if (!stack.m_41619_() || !eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41619_()) {
                            temp2 = eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41777_();
                            if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                                data.setStack(EquipmentSlot.MAINHAND, stack.m_41777_());
                            }
                            player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                            EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                            return true;
                        }
                    } else if (!(!(zPos < -arms) || stack.m_41619_() && eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41619_())) {
                        temp2 = eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41777_();
                        if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                            data.setStack(EquipmentSlot.OFFHAND, stack.m_41777_());
                        }
                        player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                        EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                        return true;
                    }
                }
                if (state.m_61143_((Property)EternalPedestalBlock.FACING) == Direction.NORTH) {
                    if (xPos > arms) {
                        if (!stack.m_41619_() || !eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41619_()) {
                            temp2 = eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41777_();
                            if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                                data.setStack(EquipmentSlot.MAINHAND, stack.m_41777_());
                            }
                            player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                            EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                            return true;
                        }
                    } else if (!(!(xPos < -arms) || stack.m_41619_() && eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41619_())) {
                        temp2 = eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41777_();
                        if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                            data.setStack(EquipmentSlot.OFFHAND, stack.m_41777_());
                        }
                        player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                        EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                        return true;
                    }
                }
                if (state.m_61143_((Property)EternalPedestalBlock.FACING) == Direction.SOUTH) {
                    if (xPos > arms) {
                        if (!stack.m_41619_() || !eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41619_()) {
                            temp2 = eternalSnapshot.getEquipment(EquipmentSlot.OFFHAND).m_41777_();
                            if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                                data.setStack(EquipmentSlot.OFFHAND, stack.m_41777_());
                            }
                            player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                            EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                            return true;
                        }
                    } else if (!(!(xPos < -arms) || stack.m_41619_() && eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41619_())) {
                        temp2 = eternalSnapshot.getEquipment(EquipmentSlot.MAINHAND).m_41777_();
                        if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                            data.setStack(EquipmentSlot.MAINHAND, stack.m_41777_());
                        }
                        player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), stack.m_41619_() ? SoundEvents.f_12016_ : SoundEvents.f_12013_, SoundSource.BLOCKS, 0.6f, 1.0f);
                        EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                        return true;
                    }
                }
            }
            if (yPos > offsets[3]) {
                if (stack.m_41619_() && !eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_41619_()) {
                    temp2 = eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_41777_();
                    soundEvent = eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_150920_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12016_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.HEAD, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                    return true;
                }
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.HEAD) {
                    EternalData data;
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_41777_();
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.HEAD, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return true;
                }
            } else {
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.HEAD && eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_41619_()) {
                    EternalData data;
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.HEAD).m_41777_();
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.HEAD, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return false;
                }
            }
            if (yPos > offsets[2] && yPos < offsets[3]) {
                if (stack.m_41619_() && !eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_41619_()) {
                    temp2 = eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_41777_();
                    soundEvent = eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_150920_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12016_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.CHEST, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                    return true;
                }
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.CHEST) {
                    EternalData data;
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_41777_();
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.CHEST, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return true;
                }
            } else {
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.CHEST && eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_41619_()) {
                    EternalData data;
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.CHEST).m_41777_();
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.CHEST, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return false;
                }
            }
            if (yPos > offsets[1] && yPos < offsets[2]) {
                if (stack.m_41619_() && !eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_41619_()) {
                    temp2 = eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_41777_();
                    soundEvent = eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_150920_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12016_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.LEGS, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                    return true;
                }
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.LEGS) {
                    EternalData data;
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_41777_();
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.LEGS, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return true;
                }
            } else {
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.LEGS && eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_41619_()) {
                    EternalData data;
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.LEGS).m_41777_();
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.LEGS, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return false;
                }
            }
            if (yPos > offsets[0] && yPos < offsets[1]) {
                if (stack.m_41619_() && !eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_41619_()) {
                    temp2 = eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_41777_();
                    soundEvent = eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_150920_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12016_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.FEET, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp2);
                    return true;
                }
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.FEET) {
                    EternalData data;
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_41777_();
                    if (player.f_19853_ instanceof ServerLevel && (data = this.getEternal()) != null) {
                        data.setStack(EquipmentSlot.FEET, stack.m_41777_());
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return true;
                }
            } else {
                soundEvent = stack.m_41720_();
                if (soundEvent instanceof ArmorItem && (armor = (ArmorItem)soundEvent).m_40402_() == EquipmentSlot.FEET && eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_41619_()) {
                    temp = eternalSnapshot.getEquipment(EquipmentSlot.FEET).m_41777_();
                    soundEvent = armor.m_142602_();
                    player.f_19853_.m_5594_(null, this.m_58899_().m_7494_(), (SoundEvent)(soundEvent != null ? soundEvent : SoundEvents.f_12013_), SoundSource.BLOCKS, 0.6f, 1.0f);
                    Level level2 = player.f_19853_;
                    if (level2 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level2;
                        EternalData data = this.getEternal();
                        if (data != null) {
                            data.setStack(EquipmentSlot.FEET, stack.m_41777_());
                        }
                    }
                    EternalPedestalTileEntity.setItemInPlayerHandNoSound(player, hand, temp);
                    return false;
                }
            }
        } else {
            if (this.eternalId == null && !player.m_20197_().isEmpty() && (temp = player.m_20197_().get(0)) instanceof EternalSpiritEntity) {
                EternalSpiritEntity spirit = (EternalSpiritEntity)temp;
                this.eternalId = spirit.getEternalUUID();
                if (player.f_19853_ instanceof ServerLevel) {
                    spirit.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                if ((soundEvent = player.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)soundEvent;
                    data = EternalsData.get(serverLevel).getEternal(this.eternalId);
                    if (data != null) {
                        this.skinProfile.updateSkin(data.getName());
                    }
                } else {
                    EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(this.eternalId);
                    if (snapshot != null) {
                        this.skinProfile.updateSkin(snapshot.getName());
                    }
                }
                this.m_6596_();
                return true;
            }
            if (this.eternalId != null) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> buffer.m_130064_(this.f_58858_));
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new CryochamberContainer(windowId, this.m_58904_(), this.m_58899_(), playerInventory);
    }

    public static void setItemInPlayerHandNoSound(Player player, InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.OFF_HAND) {
            player.m_150109_().f_35976_.set(0, (Object)stack);
        }
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
        }
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    public SkinProfile getSkinProfile() {
        return this.skinProfile;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return Optional.ofNullable(this.gameProfile);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.gameProfile != null) {
            tag.m_128365_(GAME_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        if (this.owner != null) {
            tag.m_128362_(OWNER_TAG, this.owner);
        }
        if (this.eternalId != null) {
            tag.m_128362_(ETERNAL_TAG, this.eternalId);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setGameProfile(tag.m_128441_(GAME_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_(GAME_PROFILE_TAG)) : null);
        if (tag.m_128441_(OWNER_TAG)) {
            this.owner = tag.m_128342_(OWNER_TAG);
        }
        if (tag.m_128441_(ETERNAL_TAG)) {
            this.eternalId = tag.m_128342_(ETERNAL_TAG);
            this.updateSkin = true;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EternalPedestalTileEntity tile) {
        EternalDataSnapshot snapshot;
        if (!level.m_5776_()) {
            if (state.m_61138_(EternalPedestalBlock.HALF) && state.m_61143_(EternalPedestalBlock.HALF) == EternalPedestalBlock.TripleBlock.LOWER) {
                BlockState middle = level.m_8055_(pos.m_7494_());
                BlockState up = level.m_8055_(pos.m_7494_().m_7494_());
                if (!(up.m_60734_() instanceof EternalPedestalBlock) && up.m_60767_().m_76336_()) {
                    level.m_46597_(pos.m_7494_().m_7494_(), (BlockState)((BlockState)state.m_60734_().m_49966_().m_61124_(EternalPedestalBlock.HALF, (Comparable)((Object)EternalPedestalBlock.TripleBlock.UPPER))).m_61124_((Property)EternalPedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)EternalPedestalBlock.FACING))));
                }
                if (!(middle.m_60734_() instanceof EternalPedestalBlock) && middle.m_60767_().m_76336_()) {
                    level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)state.m_60734_().m_49966_().m_61124_(EternalPedestalBlock.HALF, (Comparable)((Object)EternalPedestalBlock.TripleBlock.MIDDLE))).m_61124_((Property)EternalPedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)EternalPedestalBlock.FACING))));
                }
            }
        } else if (tile.updateSkin && (snapshot = ClientEternalData.getSnapshot(tile.eternalId)) != null) {
            tile.skinProfile.updateSkin(snapshot.getName());
            tile.updateSkin = false;
        }
    }

    @Nullable
    public EternalData getEternal() {
        if (this.m_58904_() == null) {
            return null;
        }
        if (!this.m_58904_().m_5776_()) {
            if (this.eternalId == null) {
                return null;
            }
            return EternalsData.get((ServerLevel)this.m_58904_()).getEternals(this.owner).get(this.eternalId);
        }
        return null;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 2.0, 0.0);
    }

    public Component m_5446_() {
        EternalData eternal = this.getEternal();
        if (eternal != null) {
            return new TextComponent(eternal.getName());
        }
        return new TextComponent("Cryo Chamber");
    }
}

