/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.GateLockBlock;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.loot.entry.ItemLootEntry;
import iskallia.vault.core.world.template.data.IndirectTemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GateLockTileEntity
extends BlockEntity {
    private Step step = Step.PLACED;
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;
    private TemplatePool room;
    private TemplatePool tunnel;
    private String fullName;
    private String tunnelName;
    private int color;
    private VaultGod god;
    private List<ItemLootEntry> fullCost = new ArrayList<ItemLootEntry>();
    private List<ItemLootEntry> tunnelCost = new ArrayList<ItemLootEntry>();
    private State state;
    private List<OverSizedItemStack> cost = new ArrayList<OverSizedItemStack>();
    private int reputationCost;
    private ResourceLocation modifierPool;
    private List<VaultModifierStack> modifiers = new ArrayList<VaultModifierStack>();

    public GateLockTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public GateLockTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.GATE_LOCK_TILE_ENTITY, pos, state);
    }

    public Step getStep() {
        return this.step;
    }

    public VaultGod getGod() {
        return this.god;
    }

    public TemplatePool getRoom() {
        return this.room;
    }

    public TemplatePool getTunnel() {
        return this.tunnel;
    }

    public String getName() {
        return this.state == State.TUNNEL_AND_ROOM ? this.fullName : this.tunnelName;
    }

    public int getColor() {
        return this.color;
    }

    public State getState() {
        return this.state;
    }

    public List<ItemStack> getCost() {
        return this.cost.stream().map(OverSizedItemStack::overSizedStack).toList();
    }

    public List<OverSizedItemStack> getOversizedCost() {
        return this.cost;
    }

    public int getReputationCost() {
        return this.reputationCost;
    }

    public List<VaultModifierStack> getModifiers() {
        return this.modifiers;
    }

    public void setStep(Step step) {
        this.step = step;
        this.sendUpdates();
    }

    public void setState(State state) {
        this.state = state;
        this.sendUpdates();
    }

    public void setReputationCost(int reputationCost) {
        this.reputationCost = reputationCost;
        this.sendUpdates();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public void m_142466_(CompoundTag nbt) {
        ListTag list;
        Object palettes;
        ResourceLocation reference;
        super.m_142466_(nbt);
        this.step = Adapters.ofEnum(Step.class, EnumAdapter.Mode.NAME).readNbt(nbt.m_128423_("Step")).orElse(Step.PLACED);
        this.offsetX = Adapters.INT.readNbt(nbt.m_128423_("OffsetX")).orElse(0);
        this.offsetY = Adapters.INT.readNbt(nbt.m_128423_("OffsetY")).orElse(0);
        this.width = Adapters.INT.readNbt(nbt.m_128423_("Width")).orElse(0);
        this.height = Adapters.INT.readNbt(nbt.m_128423_("Height")).orElse(0);
        this.god = Adapters.GOD_NAME.readNbt(nbt.m_128423_("God")).orElse(null);
        if (nbt.m_128425_("RoomReference", 8)) {
            reference = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("RoomReference")).orElseThrow();
            palettes = new ArrayList<ResourceLocation>();
            if (nbt.m_128425_("RoomPalettes", 9)) {
                list = nbt.m_128437_("RoomPalettes", 8);
                for (Tag tag2 : list) {
                    Adapters.IDENTIFIER.readNbt(tag2).ifPresent(arg_0 -> palettes.add(arg_0));
                }
            }
            this.room = (TemplatePool)new TemplatePool().addLeaf(new IndirectTemplateEntry(reference, (List<ResourceLocation>)palettes), 1.0);
        } else {
            this.room = Adapters.TEMPLATE_POOL.readNbt((ListTag)nbt.m_128423_("Room")).orElse(null);
        }
        if (nbt.m_128425_("TunnelReference", 8)) {
            reference = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("TunnelReference")).orElseThrow();
            palettes = new ArrayList();
            if (nbt.m_128425_("TunnelPalettes", 9)) {
                list = nbt.m_128437_("TunnelPalettes", 8);
                for (Tag tag2 : list) {
                    Adapters.IDENTIFIER.readNbt(tag2).ifPresent(arg_0 -> palettes.add(arg_0));
                }
            }
            this.tunnel = (TemplatePool)new TemplatePool().addLeaf(new IndirectTemplateEntry(reference, (List<ResourceLocation>)palettes), 1.0);
        } else {
            this.tunnel = Adapters.TEMPLATE_POOL.readNbt((ListTag)nbt.m_128423_("Tunnel")).orElse(null);
        }
        this.fullName = Adapters.UTF_8.readNbt(nbt.m_128423_("FullName")).orElse("Unknown");
        this.tunnelName = Adapters.UTF_8.readNbt(nbt.m_128423_("TunnelName")).orElse("Unknown");
        this.color = Adapters.INT.readNbt(nbt.m_128423_("Color")).orElse(0xFFFFFF);
        this.fullCost = new ArrayList<ItemLootEntry>();
        nbt.m_128437_("FullCost", 10).forEach(tag -> this.fullCost.add(new ItemLootEntry((Tag)tag)));
        this.tunnelCost = new ArrayList<ItemLootEntry>();
        nbt.m_128437_("TunnelCost", 10).forEach(tag -> this.tunnelCost.add(new ItemLootEntry((Tag)tag)));
        this.state = Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).readNbt(nbt.m_128423_("State")).orElse(null);
        ListTag list2 = nbt.m_128437_("Cost", 10);
        this.cost = new ArrayList<OverSizedItemStack>();
        for (Tag tag3 : list2) {
            Adapters.ITEM_STACK.readNbt(tag3).ifPresent(stack -> this.cost.add(OverSizedItemStack.of(stack)));
        }
        this.reputationCost = Adapters.INT.readNbt(nbt.m_128423_("ReputationCost")).orElse(0);
        this.modifierPool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("ModifierPool")).orElse(null);
        this.modifiers = new ArrayList<VaultModifierStack>();
        ListTag modifierList = nbt.m_128437_("Modifiers", 10);
        for (Tag tag4 : modifierList) {
            this.modifiers.add(VaultModifierStack.of((CompoundTag)tag4));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.ofEnum(Step.class, EnumAdapter.Mode.NAME).writeNbt(this.step).ifPresent(tag -> nbt.m_128365_("Step", tag));
        Adapters.INT.writeNbt(this.offsetX).ifPresent(tag -> nbt.m_128365_("OffsetX", tag));
        Adapters.INT.writeNbt(this.offsetY).ifPresent(tag -> nbt.m_128365_("OffsetY", tag));
        Adapters.INT.writeNbt(this.width).ifPresent(tag -> nbt.m_128365_("Width", tag));
        Adapters.INT.writeNbt(this.height).ifPresent(tag -> nbt.m_128365_("Height", tag));
        Adapters.GOD_NAME.writeNbt(this.god).ifPresent(tag -> nbt.m_128365_("God", tag));
        Adapters.TEMPLATE_POOL.writeNbt(this.room).ifPresent(tag -> nbt.m_128365_("Room", (Tag)tag));
        Adapters.TEMPLATE_POOL.writeNbt(this.tunnel).ifPresent(tag -> nbt.m_128365_("Tunnel", (Tag)tag));
        Adapters.UTF_8.writeNbt(this.fullName).ifPresent(tag -> nbt.m_128365_("FullName", tag));
        Adapters.UTF_8.writeNbt(this.tunnelName).ifPresent(tag -> nbt.m_128365_("TunnelName", tag));
        Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.m_128365_("Color", tag));
        ListTag list1 = new ListTag();
        for (ItemLootEntry itemLootEntry : this.fullCost) {
            itemLootEntry.writeNbt().ifPresent(arg_0 -> list1.add(arg_0));
        }
        nbt.m_128365_("FullCost", (Tag)list1);
        ListTag list2 = new ListTag();
        for (ItemLootEntry itemLootEntry : this.tunnelCost) {
            itemLootEntry.writeNbt().ifPresent(arg_0 -> list2.add(arg_0));
        }
        nbt.m_128365_("TunnelCost", (Tag)list2);
        Adapters.ofEnum(State.class, EnumAdapter.Mode.NAME).writeNbt(this.state).ifPresent(tag -> nbt.m_128365_("State", tag));
        ListTag listTag = new ListTag();
        for (OverSizedItemStack stack : this.cost) {
            Adapters.ITEM_STACK.writeNbt(stack.overSizedStack()).ifPresent(arg_0 -> listTag.add(arg_0));
        }
        nbt.m_128365_("Cost", (Tag)listTag);
        Adapters.INT.writeNbt(this.reputationCost).ifPresent(tag -> nbt.m_128365_("ReputationCost", tag));
        Adapters.IDENTIFIER.writeNbt(this.modifierPool).ifPresent(tag -> nbt.m_128365_("ModifierPool", tag));
        ListTag listTag2 = new ListTag();
        for (VaultModifierStack modifier : this.modifiers) {
            listTag2.add((Object)modifier.serializeNBT());
        }
        nbt.m_128365_("Modifiers", (Tag)listTag2);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GateLockTileEntity tile) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (tile.getStep() == Step.PLACED) {
            GateLockTileEntity.fillGate(world, pos, state, tile);
            tile.setStep(Step.GENERATED);
        } else if (tile.getStep() == Step.REMOVED) {
            tile.iterate(pos, (Direction)state.m_61143_((Property)GateLockBlock.FACING), p -> world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3));
        }
        if (level.m_46467_() % 20L == 0L) {
            CommonEvents.GATE_LOCK_UPDATE.invoke((Level)world, state, pos, tile);
        }
    }

    public void iterate(BlockPos pos, Direction facing, Consumer<BlockPos> consumer) {
        Direction planeX = switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> Direction.EAST;
            default -> Direction.SOUTH;
        };
        Direction planeY = switch (facing) {
            case Direction.UP, Direction.DOWN -> Direction.EAST;
            default -> Direction.UP;
        };
        BlockPos min = pos.m_5484_(planeX, this.offsetX).m_5484_(planeY, this.offsetY);
        BlockPos max = min.m_5484_(planeX, this.width - 1).m_5484_(planeY, this.height - 1);
        for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
                    consumer.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    public static void fillGate(ServerLevel world, BlockPos pos, BlockState state, GateLockTileEntity entity) {
        Direction direction = (Direction)state.m_61143_((Property)GateLockBlock.FACING);
        entity.iterate(pos, direction, p -> {
            if (pos.equals(p)) {
                return;
            }
            world.m_7731_(p, ModBlocks.POLISHED_VAULT_STONE.m_49966_(), 3);
        });
    }

    public void onOpen(Level world, Player player, BlockPos pos, BlockState state) {
        CommonEvents.GATE_LOCK_UPDATE.invoke(world, state, pos, this);
        CommonEvents.GATE_LOCK_OPEN.invoke(world, player, pos, this);
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)GateLockBlock.FACING);
    }

    public void generateCostAndModifiers(ChunkRandom random) {
        List<ItemLootEntry> table = this.state == State.TUNNEL ? this.tunnelCost : this.fullCost;
        this.cost.clear();
        if (table != null) {
            for (ItemLootEntry entry : table) {
                this.cost.add(entry.getOverStack(random));
            }
        }
        this.modifiers.clear();
        if (this.modifierPool != null && this.state == State.TUNNEL_AND_ROOM) {
            HashMap<VaultModifier, Integer> map = new HashMap<VaultModifier, Integer>();
            ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.modifierPool, 0, random).forEach(modifier -> map.put((VaultModifier)modifier, map.getOrDefault(modifier, 0) + 1));
            map.forEach((id, count) -> this.modifiers.add(VaultModifierStack.of(id, count)));
        }
        this.sendUpdates();
    }

    public static enum Step {
        PLACED,
        GENERATED,
        REMOVED;

    }

    public static enum State {
        TUNNEL,
        TUNNEL_AND_ROOM;

    }
}

