/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.client.particles.GridGatewayParticle;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class GreedPillarTileEntity
extends BlockEntity {
    private static final int GRAY_COLOR = -11184811;
    private static final int LIGHT_CHECK_INTERVAL = 20;
    private int lightCheckCooldown = 0;
    private int lastLight = 0;
    private int completedTasks = 0;

    public GreedPillarTileEntity(BlockPos pPos, BlockState pState) {
        super(ModBlocks.GREED_PILLAR_TILE_ENTITY, pPos, pState);
    }

    public int getCompletedTasks() {
        return this.completedTasks;
    }

    public void setCompletedTasks(int completedTasks) {
        this.completedTasks = completedTasks;
        this.sendUpdates();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.completedTasks = nbt.m_128451_("completedTasks");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("completedTasks", this.completedTasks);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level pLevel, BlockPos pPos, BlockState pState, GreedPillarTileEntity pBlockEntity) {
        int completedTasks = pBlockEntity.completedTasks;
        if (completedTasks > 0) {
            GreedPillarTileEntity.addBottomSideParticles(pPos, Direction.EAST, pBlockEntity, completedTasks, 0);
            GreedPillarTileEntity.addBottomSideParticles(pPos, Direction.WEST, pBlockEntity, completedTasks, 1);
        }
        if (completedTasks > 1) {
            GreedPillarTileEntity.addBottomSideParticles(pPos, Direction.NORTH, pBlockEntity, completedTasks, 2);
            GreedPillarTileEntity.addBottomSideParticles(pPos, Direction.SOUTH, pBlockEntity, completedTasks, 3);
        }
        if (completedTasks > 2) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.EAST, pBlockEntity, completedTasks, 4, false);
        }
        if (completedTasks > 3) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.WEST, pBlockEntity, completedTasks, 5, false);
        }
        if (completedTasks > 4) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.NORTH, pBlockEntity, completedTasks, 6, false);
        }
        if (completedTasks > 5) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.SOUTH, pBlockEntity, completedTasks, 7, false);
        }
        if (completedTasks > 6) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.EAST, pBlockEntity, completedTasks, 8, true);
            GreedPillarTileEntity.addSideParticles(pPos, Direction.WEST, pBlockEntity, completedTasks, 9, true);
        }
        if (completedTasks > 7) {
            GreedPillarTileEntity.addSideParticles(pPos, Direction.NORTH, pBlockEntity, completedTasks, 10, true);
            GreedPillarTileEntity.addSideParticles(pPos, Direction.SOUTH, pBlockEntity, completedTasks, 11, true);
        }
        GreedPillarTileEntity.addTopParticles(pPos, pBlockEntity, completedTasks);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addTopParticles(BlockPos pos, GreedPillarTileEntity be, int completedTasks) {
        Random rnd = be.f_58857_.m_5822_();
        if (rnd.nextFloat() > 0.3f) {
            return;
        }
        for (int i = 0; i < completedTasks; ++i) {
            double randomX = (double)pos.m_123341_() + 0.5 + rnd.nextDouble(0.3) - 0.15;
            double randomZ = (double)pos.m_123343_() + 0.5 + rnd.nextDouble(0.3) - 0.15;
            double randomY = (double)(pos.m_123342_() + 1) + rnd.nextDouble(0.1);
            Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.GRID_GATEWAY.get(), randomX, randomY, randomZ, 0.04 * (double)rnd.nextFloat() - 0.02, 0.05 * (double)rnd.nextFloat(), 0.04 * (double)rnd.nextFloat() - 0.02);
            if (!(particle instanceof GridGatewayParticle)) continue;
            GridGatewayParticle gridGatewayParticle = (GridGatewayParticle)particle;
            gridGatewayParticle.setColor(be.getTintColor(12, completedTasks));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addSideParticles(BlockPos pos, Direction direction, GreedPillarTileEntity be, int completedTasks, int tintIndex, boolean top) {
        Random rnd = be.f_58857_.m_5822_();
        if (rnd.nextFloat() > 0.1f) {
            return;
        }
        double randomX = (double)pos.m_123341_() + 0.5 + (direction.m_122429_() == 0 ? rnd.nextDouble(0.6) - 0.3 : (double)direction.m_122429_() * (0.25 + rnd.nextDouble(0.12)));
        double randomZ = (double)pos.m_123343_() + 0.5 + (direction.m_122431_() == 0 ? rnd.nextDouble(0.6) - 0.3 : (double)direction.m_122431_() * (0.25 + rnd.nextDouble(0.12)));
        double randomY = (double)pos.m_123342_() + (top ? 0.575 : 0.2) + rnd.nextDouble(0.35);
        GreedPillarTileEntity.addParticle(be, completedTasks, tintIndex, randomX, randomY, randomZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addBottomSideParticles(BlockPos pos, Direction direction, GreedPillarTileEntity be, int completedTasks, int tintIndex) {
        Random rnd = be.f_58857_.m_5822_();
        if (rnd.nextFloat() > 0.1f) {
            return;
        }
        double randomX = (double)pos.m_123341_() + 0.5 + (direction.m_122429_() == 0 ? rnd.nextDouble(0.7) - 0.35 : (double)direction.m_122429_() * (0.4 + rnd.nextDouble(0.1)));
        double randomZ = (double)pos.m_123343_() + 0.5 + (direction.m_122431_() == 0 ? rnd.nextDouble(0.7) - 0.35 : (double)direction.m_122431_() * (0.4 + rnd.nextDouble(0.1)));
        double randomY = (double)pos.m_123342_() + 0.1 + rnd.nextDouble(0.1);
        GreedPillarTileEntity.addParticle(be, completedTasks, tintIndex, randomX, randomY, randomZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addParticle(GreedPillarTileEntity be, int completedTasks, int tintIndex, double randomX, double randomY, double randomZ) {
        Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.GRID_GATEWAY.get(), randomX, randomY, randomZ, 0.0, 0.0, 0.0);
        if (particle instanceof GridGatewayParticle) {
            GridGatewayParticle gridGatewayParticle = (GridGatewayParticle)particle;
            gridGatewayParticle.setColor(be.getTintColor(tintIndex, completedTasks));
        }
    }

    public int getTintColor(int tintIndex, GreedPillarTileEntity tile) {
        return this.getTintColor(tintIndex, tile.completedTasks);
    }

    public int getTintColor(int tintIndex, int completedTasks) {
        if (completedTasks > 0 && tintIndex == 12) {
            float transition = (float)(System.currentTimeMillis() % 10000L) / 10000.0f;
            return Color.getHSBColor(transition, 1.0f, 0.7f + 0.3f * (float)completedTasks / 10.0f).getRGB();
        }
        if ((tintIndex == 0 || tintIndex == 1) && completedTasks < 1 || (tintIndex == 2 || tintIndex == 3) && completedTasks < 2 || tintIndex > 3 && tintIndex - 1 > completedTasks) {
            return -11184811;
        }
        int colorShift = switch (tintIndex) {
            case 0, 1 -> 0;
            case 2, 3 -> 5;
            case 4 -> 1;
            case 5 -> 2;
            case 6 -> 6;
            case 7 -> 7;
            case 8 -> 9;
            case 9 -> 8;
            case 10 -> 4;
            case 11 -> 3;
            default -> 0;
        };
        float transition = (float)(System.currentTimeMillis() % 20000L + (long)(colorShift * 1000)) / 20000.0f;
        return Color.getHSBColor(transition, 1.0f, 1.0f).getRGB();
    }

    public int getLight() {
        return (int)((float)this.completedTasks / 10.0f * 15.0f);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, GreedPillarTileEntity gridGatewayTileEntity) {
        if (gridGatewayTileEntity.lightCheckCooldown++ >= 20) {
            gridGatewayTileEntity.lightCheckCooldown = 0;
            int light = gridGatewayTileEntity.getLight();
            if (gridGatewayTileEntity.lastLight != light) {
                gridGatewayTileEntity.lastLight = light;
                level.m_7260_(blockPos, blockState, blockState, 3);
            }
        }
        CommonEvents.GREED_PILLAR_UPDATE.invoke(level, blockState, blockPos, gridGatewayTileEntity);
    }
}

