/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.hologram.HologramElement;
import iskallia.vault.block.entity.hologram.ItemHologramElement;
import iskallia.vault.block.entity.hologram.ModelHologramElement;
import iskallia.vault.block.entity.hologram.RootHologramElement;
import iskallia.vault.block.entity.hologram.TextHologramElement;
import iskallia.vault.block.entity.hologram.model.MeshPart;
import iskallia.vault.init.ModBlocks;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class HologramTileEntity
extends BlockEntity {
    public static final Function<HologramTileEntity, HologramElement> DEFAULT_TREE = entity -> ((HologramElement)((HologramElement)new RootHologramElement((HologramTileEntity)((Object)entity)).add(new HologramElement[]{new ModelHologramElement(VaultMod.id("textures/entity/hologram/arrow.png"), 64, 64, -1, new MeshPart("main").uv(0.0f, 0.0f).cuboid(new Vector3f(-1.0f, -2.0f, -8.0f), new Vector3f(2.0f, 2.0f, 16.0f), Vector3f.f_176763_).uv(8.0f, 9.0f).cuboid(new Vector3f(1.0f, -2.0f, 5.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).uv(0.0f, 9.0f).cuboid(new Vector3f(2.0f, -2.0f, 4.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).uv(4.0f, 7.0f).cuboid(new Vector3f(3.0f, -2.0f, 3.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).uv(6.0f, 3.0f).cuboid(new Vector3f(-2.0f, -2.0f, 5.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).uv(0.0f, 5.0f).cuboid(new Vector3f(-3.0f, -2.0f, 4.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).uv(1.0f, 1.0f).cuboid(new Vector3f(-4.0f, -2.0f, 3.0f), new Vector3f(1.0f, 2.0f, 2.0f), Vector3f.f_176763_).setPivot(new Vector3f(0.0f, 1.0f, 0.0f)).setRotation(new Vector3f(0.0f, 0.0f, 0.0f))).setScale(0.75)})).add(new HologramElement[]{new TextHologramElement((Component)new TextComponent("Hello, World!"), true, true, 0xFFFFFF).setScale(0.0625)})).add(new HologramElement[]{((HologramElement)new ItemHologramElement(new ItemStack((ItemLike)Items.f_42388_), true, true).setTranslation(new Vec3(0.0, -1.0, 0.0))).add(new HologramElement[]{new ItemHologramElement(new ItemStack((ItemLike)Items.f_42390_), true, true).setTranslation(new Vec3(0.0, 2.0, 0.0))})});
    private HologramElement tree;

    public HologramTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.HOLOGRAM_TILE_ENTITY, pos, state);
    }

    public HologramElement getTree() {
        this.ensureNonNullTree();
        return this.tree;
    }

    public void setTree(HologramElement tree) {
        this.tree = tree;
        this.tree.iterate(RootHologramElement.class, root -> root.setEntity(this));
        this.m_6596_();
    }

    public void ensureNonNullTree() {
        if (this.tree == null) {
            this.setTree(DEFAULT_TREE.apply(this));
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HologramTileEntity entity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        entity.ensureNonNullTree();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        HologramElement.ADAPTER.writeNbt(this.tree).ifPresent(tag -> nbt.m_128365_("tree", tag));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.setTree(HologramElement.ADAPTER.readNbt(nbt.m_128423_("tree")).orElse(null));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }
}

